@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.inputs

import com.pulumi.azurenative.orbital.inputs.ContactProfileThirdPartyConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Contact Profile third-party partner configuration.
 * @property missionConfiguration Name of string referencing the configuration describing contact set-up for a particular mission. Expected values are those which have been created in collaboration with the partner network.
 * @property providerName Name of the third-party provider.
 */
public data class ContactProfileThirdPartyConfigurationArgs(
    public val missionConfiguration: Output<String>,
    public val providerName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.orbital.inputs.ContactProfileThirdPartyConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.orbital.inputs.ContactProfileThirdPartyConfigurationArgs =
        com.pulumi.azurenative.orbital.inputs.ContactProfileThirdPartyConfigurationArgs.builder()
            .missionConfiguration(missionConfiguration.applyValue({ args0 -> args0 }))
            .providerName(providerName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContactProfileThirdPartyConfigurationArgs].
 */
@PulumiTagMarker
public class ContactProfileThirdPartyConfigurationArgsBuilder internal constructor() {
    private var missionConfiguration: Output<String>? = null

    private var providerName: Output<String>? = null

    /**
     * @param value Name of string referencing the configuration describing contact set-up for a particular mission. Expected values are those which have been created in collaboration with the partner network.
     */
    @JvmName("faxpiwstyrmdjlvb")
    public suspend fun missionConfiguration(`value`: Output<String>) {
        this.missionConfiguration = value
    }

    /**
     * @param value Name of the third-party provider.
     */
    @JvmName("tohjshrhgydtjapk")
    public suspend fun providerName(`value`: Output<String>) {
        this.providerName = value
    }

    /**
     * @param value Name of string referencing the configuration describing contact set-up for a particular mission. Expected values are those which have been created in collaboration with the partner network.
     */
    @JvmName("dwhilawjojmxrmyh")
    public suspend fun missionConfiguration(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.missionConfiguration = mapped
    }

    /**
     * @param value Name of the third-party provider.
     */
    @JvmName("rqseuetbimmjuoet")
    public suspend fun providerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.providerName = mapped
    }

    internal fun build(): ContactProfileThirdPartyConfigurationArgs =
        ContactProfileThirdPartyConfigurationArgs(
            missionConfiguration = missionConfiguration ?: throw
                PulumiNullFieldException("missionConfiguration"),
            providerName = providerName ?: throw PulumiNullFieldException("providerName"),
        )
}
