@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.inputs

import com.pulumi.azurenative.orbital.inputs.ContactProfilesPropertiesNetworkConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Network configuration of customer virtual network.
 * @property subnetId ARM resource identifier of the subnet delegated to the Microsoft.Orbital/orbitalGateways. Needs to be at least a class C subnet, and should not have any IP created in it.
 */
public data class ContactProfilesPropertiesNetworkConfigurationArgs(
    public val subnetId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.orbital.inputs.ContactProfilesPropertiesNetworkConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.orbital.inputs.ContactProfilesPropertiesNetworkConfigurationArgs =
        com.pulumi.azurenative.orbital.inputs.ContactProfilesPropertiesNetworkConfigurationArgs.builder()
            .subnetId(subnetId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContactProfilesPropertiesNetworkConfigurationArgs].
 */
@PulumiTagMarker
public class ContactProfilesPropertiesNetworkConfigurationArgsBuilder internal constructor() {
    private var subnetId: Output<String>? = null

    /**
     * @param value ARM resource identifier of the subnet delegated to the Microsoft.Orbital/orbitalGateways. Needs to be at least a class C subnet, and should not have any IP created in it.
     */
    @JvmName("lhcaylwsanxbhxse")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value ARM resource identifier of the subnet delegated to the Microsoft.Orbital/orbitalGateways. Needs to be at least a class C subnet, and should not have any IP created in it.
     */
    @JvmName("yoppqykcovyblidf")
    public suspend fun subnetId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    internal fun build(): ContactProfilesPropertiesNetworkConfigurationArgs =
        ContactProfilesPropertiesNetworkConfigurationArgs(
            subnetId = subnetId ?: throw PulumiNullFieldException("subnetId"),
        )
}
