@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Contact Profile Link.
 * @property channels Contact Profile Link Channel.
 * @property direction Direction (Uplink or Downlink).
 * @property eirpdBW Effective Isotropic Radiated Power (EIRP) in dBW. It is the required EIRP by the customer. Not used yet.
 * @property gainOverTemperature Gain to noise temperature in db/K. It is the required G/T by the customer. Not used yet.
 * @property name Link name.
 * @property polarization Polarization. e.g. (RHCP, LHCP).
 */
public data class ContactProfileLinkResponse(
    public val channels: List<ContactProfileLinkChannelResponse>,
    public val direction: String,
    public val eirpdBW: Double? = null,
    public val gainOverTemperature: Double? = null,
    public val name: String,
    public val polarization: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.orbital.outputs.ContactProfileLinkResponse):
            ContactProfileLinkResponse = ContactProfileLinkResponse(
            channels = javaType.channels().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.orbital.kotlin.outputs.ContactProfileLinkChannelResponse.Companion.toKotlin(args0)
                })
            }),
            direction = javaType.direction(),
            eirpdBW = javaType.eirpdBW().map({ args0 -> args0 }).orElse(null),
            gainOverTemperature = javaType.gainOverTemperature().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            polarization = javaType.polarization(),
        )
    }
}
