@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin

import com.pulumi.azurenative.peering.ConnectionMonitorTestArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Connection Monitor Test class.
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2021-06-01.
 * ## Example Usage
 * ### Create or Update Connection Monitor Test
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connectionMonitorTest = new AzureNative.Peering.ConnectionMonitorTest("connectionMonitorTest", new()
 *     {
 *         ConnectionMonitorTestName = "connectionMonitorTestName",
 *         Destination = "Example Destination",
 *         DestinationPort = 443,
 *         PeeringServiceName = "peeringServiceName",
 *         ResourceGroupName = "rgName",
 *         SourceAgent = "Example Source Agent",
 *         TestFrequencyInSec = 30,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/peering/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := peering.NewConnectionMonitorTest(ctx, "connectionMonitorTest", &peering.ConnectionMonitorTestArgs{
 * 			ConnectionMonitorTestName: pulumi.String("connectionMonitorTestName"),
 * 			Destination:               pulumi.String("Example Destination"),
 * 			DestinationPort:           pulumi.Int(443),
 * 			PeeringServiceName:        pulumi.String("peeringServiceName"),
 * 			ResourceGroupName:         pulumi.String("rgName"),
 * 			SourceAgent:               pulumi.String("Example Source Agent"),
 * 			TestFrequencyInSec:        pulumi.Int(30),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.peering.ConnectionMonitorTest;
 * import com.pulumi.azurenative.peering.ConnectionMonitorTestArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connectionMonitorTest = new ConnectionMonitorTest("connectionMonitorTest", ConnectionMonitorTestArgs.builder()
 *             .connectionMonitorTestName("connectionMonitorTestName")
 *             .destination("Example Destination")
 *             .destinationPort(443)
 *             .peeringServiceName("peeringServiceName")
 *             .resourceGroupName("rgName")
 *             .sourceAgent("Example Source Agent")
 *             .testFrequencyInSec(30)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:peering:ConnectionMonitorTest connectionMonitorTestName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peeringServices/{peeringServiceName}/connectionMonitorTests/{connectionMonitorTestName}
 * ```
 * @property connectionMonitorTestName The name of the connection monitor test
 * @property destination The Connection Monitor test destination
 * @property destinationPort The Connection Monitor test destination port
 * @property peeringServiceName The name of the peering service.
 * @property resourceGroupName The name of the resource group.
 * @property sourceAgent The Connection Monitor test source agent
 * @property testFrequencyInSec The Connection Monitor test frequency in seconds
 */
public data class ConnectionMonitorTestArgs(
    public val connectionMonitorTestName: Output<String>? = null,
    public val destination: Output<String>? = null,
    public val destinationPort: Output<Int>? = null,
    public val peeringServiceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sourceAgent: Output<String>? = null,
    public val testFrequencyInSec: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.peering.ConnectionMonitorTestArgs> {
    override fun toJava(): com.pulumi.azurenative.peering.ConnectionMonitorTestArgs =
        com.pulumi.azurenative.peering.ConnectionMonitorTestArgs.builder()
            .connectionMonitorTestName(connectionMonitorTestName?.applyValue({ args0 -> args0 }))
            .destination(destination?.applyValue({ args0 -> args0 }))
            .destinationPort(destinationPort?.applyValue({ args0 -> args0 }))
            .peeringServiceName(peeringServiceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sourceAgent(sourceAgent?.applyValue({ args0 -> args0 }))
            .testFrequencyInSec(testFrequencyInSec?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionMonitorTestArgs].
 */
@PulumiTagMarker
public class ConnectionMonitorTestArgsBuilder internal constructor() {
    private var connectionMonitorTestName: Output<String>? = null

    private var destination: Output<String>? = null

    private var destinationPort: Output<Int>? = null

    private var peeringServiceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sourceAgent: Output<String>? = null

    private var testFrequencyInSec: Output<Int>? = null

    /**
     * @param value The name of the connection monitor test
     */
    @JvmName("gcxjhklmkmswgxgt")
    public suspend fun connectionMonitorTestName(`value`: Output<String>) {
        this.connectionMonitorTestName = value
    }

    /**
     * @param value The Connection Monitor test destination
     */
    @JvmName("mkkwuovctwmjsusi")
    public suspend fun destination(`value`: Output<String>) {
        this.destination = value
    }

    /**
     * @param value The Connection Monitor test destination port
     */
    @JvmName("vifkinanjdymhuut")
    public suspend fun destinationPort(`value`: Output<Int>) {
        this.destinationPort = value
    }

    /**
     * @param value The name of the peering service.
     */
    @JvmName("imjxppmgycbtycxc")
    public suspend fun peeringServiceName(`value`: Output<String>) {
        this.peeringServiceName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("jhromukfcamhkynt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The Connection Monitor test source agent
     */
    @JvmName("ferpcnoofuoofkry")
    public suspend fun sourceAgent(`value`: Output<String>) {
        this.sourceAgent = value
    }

    /**
     * @param value The Connection Monitor test frequency in seconds
     */
    @JvmName("encmcexktjlffypo")
    public suspend fun testFrequencyInSec(`value`: Output<Int>) {
        this.testFrequencyInSec = value
    }

    /**
     * @param value The name of the connection monitor test
     */
    @JvmName("geiuarlgyhtwamsi")
    public suspend fun connectionMonitorTestName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionMonitorTestName = mapped
    }

    /**
     * @param value The Connection Monitor test destination
     */
    @JvmName("ebgjxyhilwyosixv")
    public suspend fun destination(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param value The Connection Monitor test destination port
     */
    @JvmName("toutdbnjfdrddjtq")
    public suspend fun destinationPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPort = mapped
    }

    /**
     * @param value The name of the peering service.
     */
    @JvmName("mdpmliwnqkjmlcqt")
    public suspend fun peeringServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peeringServiceName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("nayhmklhdcrdtykx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Connection Monitor test source agent
     */
    @JvmName("hfgvhcwqwnohqacy")
    public suspend fun sourceAgent(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceAgent = mapped
    }

    /**
     * @param value The Connection Monitor test frequency in seconds
     */
    @JvmName("bnutcghyvqdlhhkc")
    public suspend fun testFrequencyInSec(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testFrequencyInSec = mapped
    }

    internal fun build(): ConnectionMonitorTestArgs = ConnectionMonitorTestArgs(
        connectionMonitorTestName = connectionMonitorTestName,
        destination = destination,
        destinationPort = destinationPort,
        peeringServiceName = peeringServiceName,
        resourceGroupName = resourceGroupName,
        sourceAgent = sourceAgent,
        testFrequencyInSec = testFrequencyInSec,
    )
}
