@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin

import com.pulumi.azurenative.peering.kotlin.outputs.LogAnalyticsWorkspacePropertiesResponse
import com.pulumi.azurenative.peering.kotlin.outputs.PeeringServiceSkuResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.peering.kotlin.outputs.LogAnalyticsWorkspacePropertiesResponse.Companion.toKotlin as logAnalyticsWorkspacePropertiesResponseToKotlin
import com.pulumi.azurenative.peering.kotlin.outputs.PeeringServiceSkuResponse.Companion.toKotlin as peeringServiceSkuResponseToKotlin

/**
 * Builder for [PeeringService].
 */
@PulumiTagMarker
public class PeeringServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PeeringServiceArgs = PeeringServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PeeringServiceArgsBuilder.() -> Unit) {
        val builder = PeeringServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PeeringService {
        val builtJavaResource = com.pulumi.azurenative.peering.PeeringService(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PeeringService(builtJavaResource)
    }
}

/**
 * Peering Service
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * ## Example Usage
 * ### Create a  peering service
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var peeringService = new AzureNative.Peering.PeeringService("peeringService", new()
 *     {
 *         Location = "eastus",
 *         PeeringServiceLocation = "state1",
 *         PeeringServiceName = "peeringServiceName",
 *         PeeringServiceProvider = "serviceProvider1",
 *         ProviderBackupPeeringLocation = "peeringLocation2",
 *         ProviderPrimaryPeeringLocation = "peeringLocation1",
 *         ResourceGroupName = "rgName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/peering/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := peering.NewPeeringService(ctx, "peeringService", &peering.PeeringServiceArgs{
 * 			Location:                       pulumi.String("eastus"),
 * 			PeeringServiceLocation:         pulumi.String("state1"),
 * 			PeeringServiceName:             pulumi.String("peeringServiceName"),
 * 			PeeringServiceProvider:         pulumi.String("serviceProvider1"),
 * 			ProviderBackupPeeringLocation:  pulumi.String("peeringLocation2"),
 * 			ProviderPrimaryPeeringLocation: pulumi.String("peeringLocation1"),
 * 			ResourceGroupName:              pulumi.String("rgName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.peering.PeeringService;
 * import com.pulumi.azurenative.peering.PeeringServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var peeringService = new PeeringService("peeringService", PeeringServiceArgs.builder()
 *             .location("eastus")
 *             .peeringServiceLocation("state1")
 *             .peeringServiceName("peeringServiceName")
 *             .peeringServiceProvider("serviceProvider1")
 *             .providerBackupPeeringLocation("peeringLocation2")
 *             .providerPrimaryPeeringLocation("peeringLocation1")
 *             .resourceGroupName("rgName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:peering:PeeringService peeringServiceName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peeringServices/{peeringServiceName}
 * ```
 */
public class PeeringService internal constructor(
    override val javaResource: com.pulumi.azurenative.peering.PeeringService,
) : KotlinCustomResource(javaResource, PeeringServiceMapper) {
    /**
     * The location of the resource.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The Log Analytics Workspace Properties
     */
    public val logAnalyticsWorkspaceProperties: Output<LogAnalyticsWorkspacePropertiesResponse>?
        get() = javaResource.logAnalyticsWorkspaceProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    logAnalyticsWorkspacePropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The location (state/province) of the customer.
     */
    public val peeringServiceLocation: Output<String>?
        get() = javaResource.peeringServiceLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the service provider.
     */
    public val peeringServiceProvider: Output<String>?
        get() = javaResource.peeringServiceProvider().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The backup peering (Microsoft/service provider) location to be used for customer traffic.
     */
    public val providerBackupPeeringLocation: Output<String>?
        get() = javaResource.providerBackupPeeringLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The primary peering (Microsoft/service provider) location to be used for customer traffic.
     */
    public val providerPrimaryPeeringLocation: Output<String>?
        get() = javaResource.providerPrimaryPeeringLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The SKU that defines the type of the peering service.
     */
    public val sku: Output<PeeringServiceSkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    peeringServiceSkuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PeeringServiceMapper : ResourceMapper<PeeringService> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.peering.PeeringService::class == javaResource::class

    override fun map(javaResource: Resource): PeeringService = PeeringService(
        javaResource as
            com.pulumi.azurenative.peering.PeeringService,
    )
}

/**
 * @see [PeeringService].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PeeringService].
 */
public suspend fun peeringService(
    name: String,
    block: suspend PeeringServiceResourceBuilder.() -> Unit,
): PeeringService {
    val builder = PeeringServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PeeringService].
 * @param name The _unique_ name of the resulting resource.
 */
public fun peeringService(name: String): PeeringService {
    val builder = PeeringServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
