@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin

import com.pulumi.azurenative.peering.RegisteredAsnArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The customer's ASN that is registered by the peering service provider.
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * ## Example Usage
 * ### Create or update a registered ASN for the peering
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registeredAsn = new AzureNative.Peering.RegisteredAsn("registeredAsn", new()
 *     {
 *         Asn = 65000,
 *         PeeringName = "peeringName",
 *         RegisteredAsnName = "registeredAsnName",
 *         ResourceGroupName = "rgName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/peering/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := peering.NewRegisteredAsn(ctx, "registeredAsn", &peering.RegisteredAsnArgs{
 * 			Asn:               pulumi.Int(65000),
 * 			PeeringName:       pulumi.String("peeringName"),
 * 			RegisteredAsnName: pulumi.String("registeredAsnName"),
 * 			ResourceGroupName: pulumi.String("rgName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.peering.RegisteredAsn;
 * import com.pulumi.azurenative.peering.RegisteredAsnArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registeredAsn = new RegisteredAsn("registeredAsn", RegisteredAsnArgs.builder()
 *             .asn(65000)
 *             .peeringName("peeringName")
 *             .registeredAsnName("registeredAsnName")
 *             .resourceGroupName("rgName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:peering:RegisteredAsn registeredAsnName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peerings/{peeringName}/registeredAsns/{registeredAsnName}
 * ```
 * @property asn The customer's ASN from which traffic originates.
 * @property peeringName The name of the peering.
 * @property registeredAsnName The name of the ASN.
 * @property resourceGroupName The name of the resource group.
 */
public data class RegisteredAsnArgs(
    public val asn: Output<Int>? = null,
    public val peeringName: Output<String>? = null,
    public val registeredAsnName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.peering.RegisteredAsnArgs> {
    override fun toJava(): com.pulumi.azurenative.peering.RegisteredAsnArgs =
        com.pulumi.azurenative.peering.RegisteredAsnArgs.builder()
            .asn(asn?.applyValue({ args0 -> args0 }))
            .peeringName(peeringName?.applyValue({ args0 -> args0 }))
            .registeredAsnName(registeredAsnName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegisteredAsnArgs].
 */
@PulumiTagMarker
public class RegisteredAsnArgsBuilder internal constructor() {
    private var asn: Output<Int>? = null

    private var peeringName: Output<String>? = null

    private var registeredAsnName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The customer's ASN from which traffic originates.
     */
    @JvmName("bxsxvovwdxpaxxao")
    public suspend fun asn(`value`: Output<Int>) {
        this.asn = value
    }

    /**
     * @param value The name of the peering.
     */
    @JvmName("efomaxxpitqclyku")
    public suspend fun peeringName(`value`: Output<String>) {
        this.peeringName = value
    }

    /**
     * @param value The name of the ASN.
     */
    @JvmName("iamlqdlokfiyudvd")
    public suspend fun registeredAsnName(`value`: Output<String>) {
        this.registeredAsnName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("qduwaluhiqvfbfax")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The customer's ASN from which traffic originates.
     */
    @JvmName("igowqeuaxtpdqbyd")
    public suspend fun asn(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.asn = mapped
    }

    /**
     * @param value The name of the peering.
     */
    @JvmName("skngvbgfeaxmnfun")
    public suspend fun peeringName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peeringName = mapped
    }

    /**
     * @param value The name of the ASN.
     */
    @JvmName("qqlbmmchirrgpsam")
    public suspend fun registeredAsnName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registeredAsnName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("mbaudsgnpewrbhru")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): RegisteredAsnArgs = RegisteredAsnArgs(
        asn = asn,
        peeringName = peeringName,
        registeredAsnName = registeredAsnName,
        resourceGroupName = resourceGroupName,
    )
}
