@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.inputs

import com.pulumi.azurenative.peering.inputs.GetConnectionMonitorTestPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectionMonitorTestName The name of the connection monitor test
 * @property peeringServiceName The name of the peering service.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetConnectionMonitorTestPlainArgs(
    public val connectionMonitorTestName: String,
    public val peeringServiceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.peering.inputs.GetConnectionMonitorTestPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.peering.inputs.GetConnectionMonitorTestPlainArgs =
        com.pulumi.azurenative.peering.inputs.GetConnectionMonitorTestPlainArgs.builder()
            .connectionMonitorTestName(connectionMonitorTestName.let({ args0 -> args0 }))
            .peeringServiceName(peeringServiceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConnectionMonitorTestPlainArgs].
 */
@PulumiTagMarker
public class GetConnectionMonitorTestPlainArgsBuilder internal constructor() {
    private var connectionMonitorTestName: String? = null

    private var peeringServiceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the connection monitor test
     */
    @JvmName("ayveqsxmxpmkdtfp")
    public suspend fun connectionMonitorTestName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectionMonitorTestName = mapped
    }

    /**
     * @param value The name of the peering service.
     */
    @JvmName("aptktupxsvruvdvg")
    public suspend fun peeringServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.peeringServiceName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("oabyeylpufcjrciq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetConnectionMonitorTestPlainArgs = GetConnectionMonitorTestPlainArgs(
        connectionMonitorTestName = connectionMonitorTestName ?: throw
            PulumiNullFieldException("connectionMonitorTestName"),
        peeringServiceName = peeringServiceName ?: throw PulumiNullFieldException("peeringServiceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
