@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.inputs

import com.pulumi.azurenative.peering.inputs.PeeringSkuArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The SKU that defines the tier and kind of the peering.
 * @property name The name of the peering SKU.
 */
public data class PeeringSkuArgs(
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.peering.inputs.PeeringSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.peering.inputs.PeeringSkuArgs =
        com.pulumi.azurenative.peering.inputs.PeeringSkuArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PeeringSkuArgs].
 */
@PulumiTagMarker
public class PeeringSkuArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value The name of the peering SKU.
     */
    @JvmName("qmhyrywcnaaqwyyk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the peering SKU.
     */
    @JvmName("hibrpnpyqxkejqjf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): PeeringSkuArgs = PeeringSkuArgs(
        name = name,
    )
}
