@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The properties that define a BGP session.
 * @property maxPrefixesAdvertisedV4 The maximum number of prefixes advertised over the IPv4 session.
 * @property maxPrefixesAdvertisedV6 The maximum number of prefixes advertised over the IPv6 session.
 * @property md5AuthenticationKey The MD5 authentication key of the session.
 * @property microsoftSessionIPv4Address The IPv4 session address on Microsoft's end.
 * @property microsoftSessionIPv6Address The IPv6 session address on Microsoft's end.
 * @property peerSessionIPv4Address The IPv4 session address on peer's end.
 * @property peerSessionIPv6Address The IPv6 session address on peer's end.
 * @property sessionPrefixV4 The IPv4 prefix that contains both ends' IPv4 addresses.
 * @property sessionPrefixV6 The IPv6 prefix that contains both ends' IPv6 addresses.
 * @property sessionStateV4 The state of the IPv4 session.
 * @property sessionStateV6 The state of the IPv6 session.
 */
public data class BgpSessionResponse(
    public val maxPrefixesAdvertisedV4: Int? = null,
    public val maxPrefixesAdvertisedV6: Int? = null,
    public val md5AuthenticationKey: String? = null,
    public val microsoftSessionIPv4Address: String? = null,
    public val microsoftSessionIPv6Address: String? = null,
    public val peerSessionIPv4Address: String? = null,
    public val peerSessionIPv6Address: String? = null,
    public val sessionPrefixV4: String? = null,
    public val sessionPrefixV6: String? = null,
    public val sessionStateV4: String,
    public val sessionStateV6: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.peering.outputs.BgpSessionResponse):
            BgpSessionResponse = BgpSessionResponse(
            maxPrefixesAdvertisedV4 = javaType.maxPrefixesAdvertisedV4().map({ args0 -> args0 }).orElse(null),
            maxPrefixesAdvertisedV6 = javaType.maxPrefixesAdvertisedV6().map({ args0 -> args0 }).orElse(null),
            md5AuthenticationKey = javaType.md5AuthenticationKey().map({ args0 -> args0 }).orElse(null),
            microsoftSessionIPv4Address = javaType.microsoftSessionIPv4Address().map({ args0 ->
                args0
            }).orElse(null),
            microsoftSessionIPv6Address = javaType.microsoftSessionIPv6Address().map({ args0 ->
                args0
            }).orElse(null),
            peerSessionIPv4Address = javaType.peerSessionIPv4Address().map({ args0 -> args0 }).orElse(null),
            peerSessionIPv6Address = javaType.peerSessionIPv6Address().map({ args0 -> args0 }).orElse(null),
            sessionPrefixV4 = javaType.sessionPrefixV4().map({ args0 -> args0 }).orElse(null),
            sessionPrefixV6 = javaType.sessionPrefixV6().map({ args0 -> args0 }).orElse(null),
            sessionStateV4 = javaType.sessionStateV4(),
            sessionStateV6 = javaType.sessionStateV6(),
        )
    }
}
