@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The SKU that defines the type of the peering service.
 * @property name The name of the peering service SKU.
 */
public data class PeeringServiceSkuResponse(
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.peering.outputs.PeeringServiceSkuResponse):
            PeeringServiceSkuResponse = PeeringServiceSkuResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
