@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.policyinsights.kotlin

import com.pulumi.azurenative.policyinsights.RemediationAtResourceArgs.builder
import com.pulumi.azurenative.policyinsights.kotlin.enums.ResourceDiscoveryMode
import com.pulumi.azurenative.policyinsights.kotlin.inputs.RemediationFiltersArgs
import com.pulumi.azurenative.policyinsights.kotlin.inputs.RemediationFiltersArgsBuilder
import com.pulumi.azurenative.policyinsights.kotlin.inputs.RemediationPropertiesFailureThresholdArgs
import com.pulumi.azurenative.policyinsights.kotlin.inputs.RemediationPropertiesFailureThresholdArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The remediation definition.
 * Azure REST API version: 2021-10-01. Prior API version in Azure Native 1.x: 2019-07-01.
 * Other available API versions: 2018-07-01-preview.
 * ## Example Usage
 * ### Create remediation at individual resource scope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var remediationAtResource = new AzureNative.PolicyInsights.RemediationAtResource("remediationAtResource", new()
 *     {
 *         PolicyAssignmentId = "/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourceGroups/myResourceGroup/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5",
 *         RemediationName = "storageRemediation",
 *         ResourceId = "subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.storage/storageaccounts/storAc1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/policyinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := policyinsights.NewRemediationAtResource(ctx, "remediationAtResource", &policyinsights.RemediationAtResourceArgs{
 * 			PolicyAssignmentId: pulumi.String("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourceGroups/myResourceGroup/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
 * 			RemediationName:    pulumi.String("storageRemediation"),
 * 			ResourceId:         pulumi.String("subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.storage/storageaccounts/storAc1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.policyinsights.RemediationAtResource;
 * import com.pulumi.azurenative.policyinsights.RemediationAtResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var remediationAtResource = new RemediationAtResource("remediationAtResource", RemediationAtResourceArgs.builder()
 *             .policyAssignmentId("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourceGroups/myResourceGroup/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5")
 *             .remediationName("storageRemediation")
 *             .resourceId("subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.storage/storageaccounts/storAc1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:policyinsights:RemediationAtResource storageRemediation /{resourceId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}
 * ```
 * @property failureThreshold The remediation failure threshold settings
 * @property filters The filters that will be applied to determine which resources to remediate.
 * @property parallelDeployments Determines how many resources to remediate at any given time. Can be used to increase or reduce the pace of the remediation. If not provided, the default parallel deployments value is used.
 * @property policyAssignmentId The resource ID of the policy assignment that should be remediated.
 * @property policyDefinitionReferenceId The policy definition reference ID of the individual definition that should be remediated. Required when the policy assignment being remediated assigns a policy set definition.
 * @property remediationName The name of the remediation.
 * @property resourceCount Determines the max number of resources that can be remediated by the remediation job. If not provided, the default resource count is used.
 * @property resourceDiscoveryMode The way resources to remediate are discovered. Defaults to ExistingNonCompliant if not specified.
 * @property resourceId Resource ID.
 */
public data class RemediationAtResourceArgs(
    public val failureThreshold: Output<RemediationPropertiesFailureThresholdArgs>? = null,
    public val filters: Output<RemediationFiltersArgs>? = null,
    public val parallelDeployments: Output<Int>? = null,
    public val policyAssignmentId: Output<String>? = null,
    public val policyDefinitionReferenceId: Output<String>? = null,
    public val remediationName: Output<String>? = null,
    public val resourceCount: Output<Int>? = null,
    public val resourceDiscoveryMode: Output<Either<String, ResourceDiscoveryMode>>? = null,
    public val resourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.policyinsights.RemediationAtResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.policyinsights.RemediationAtResourceArgs =
        com.pulumi.azurenative.policyinsights.RemediationAtResourceArgs.builder()
            .failureThreshold(failureThreshold?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .filters(filters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .parallelDeployments(parallelDeployments?.applyValue({ args0 -> args0 }))
            .policyAssignmentId(policyAssignmentId?.applyValue({ args0 -> args0 }))
            .policyDefinitionReferenceId(policyDefinitionReferenceId?.applyValue({ args0 -> args0 }))
            .remediationName(remediationName?.applyValue({ args0 -> args0 }))
            .resourceCount(resourceCount?.applyValue({ args0 -> args0 }))
            .resourceDiscoveryMode(
                resourceDiscoveryMode?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RemediationAtResourceArgs].
 */
@PulumiTagMarker
public class RemediationAtResourceArgsBuilder internal constructor() {
    private var failureThreshold: Output<RemediationPropertiesFailureThresholdArgs>? = null

    private var filters: Output<RemediationFiltersArgs>? = null

    private var parallelDeployments: Output<Int>? = null

    private var policyAssignmentId: Output<String>? = null

    private var policyDefinitionReferenceId: Output<String>? = null

    private var remediationName: Output<String>? = null

    private var resourceCount: Output<Int>? = null

    private var resourceDiscoveryMode: Output<Either<String, ResourceDiscoveryMode>>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value The remediation failure threshold settings
     */
    @JvmName("jkgahkmftxbhaeua")
    public suspend fun failureThreshold(`value`: Output<RemediationPropertiesFailureThresholdArgs>) {
        this.failureThreshold = value
    }

    /**
     * @param value The filters that will be applied to determine which resources to remediate.
     */
    @JvmName("rwpsgxomrufvwchf")
    public suspend fun filters(`value`: Output<RemediationFiltersArgs>) {
        this.filters = value
    }

    /**
     * @param value Determines how many resources to remediate at any given time. Can be used to increase or reduce the pace of the remediation. If not provided, the default parallel deployments value is used.
     */
    @JvmName("jmctoqlttfrkiqoa")
    public suspend fun parallelDeployments(`value`: Output<Int>) {
        this.parallelDeployments = value
    }

    /**
     * @param value The resource ID of the policy assignment that should be remediated.
     */
    @JvmName("qsknxdwwmoamajex")
    public suspend fun policyAssignmentId(`value`: Output<String>) {
        this.policyAssignmentId = value
    }

    /**
     * @param value The policy definition reference ID of the individual definition that should be remediated. Required when the policy assignment being remediated assigns a policy set definition.
     */
    @JvmName("dvjfkokmrousedyy")
    public suspend fun policyDefinitionReferenceId(`value`: Output<String>) {
        this.policyDefinitionReferenceId = value
    }

    /**
     * @param value The name of the remediation.
     */
    @JvmName("jugywhamxpyytrcv")
    public suspend fun remediationName(`value`: Output<String>) {
        this.remediationName = value
    }

    /**
     * @param value Determines the max number of resources that can be remediated by the remediation job. If not provided, the default resource count is used.
     */
    @JvmName("bgjssfuwbntoqybs")
    public suspend fun resourceCount(`value`: Output<Int>) {
        this.resourceCount = value
    }

    /**
     * @param value The way resources to remediate are discovered. Defaults to ExistingNonCompliant if not specified.
     */
    @JvmName("bbcnighgreuvwkly")
    public suspend fun resourceDiscoveryMode(`value`: Output<Either<String, ResourceDiscoveryMode>>) {
        this.resourceDiscoveryMode = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("xyruuthfjpuwhame")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The remediation failure threshold settings
     */
    @JvmName("xsxdjcknjljyfhny")
    public suspend fun failureThreshold(`value`: RemediationPropertiesFailureThresholdArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureThreshold = mapped
    }

    /**
     * @param argument The remediation failure threshold settings
     */
    @JvmName("iceyjechavfvopyl")
    public suspend
    fun failureThreshold(argument: suspend RemediationPropertiesFailureThresholdArgsBuilder.() -> Unit) {
        val toBeMapped = RemediationPropertiesFailureThresholdArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.failureThreshold = mapped
    }

    /**
     * @param value The filters that will be applied to determine which resources to remediate.
     */
    @JvmName("tielkfljkkkyaqfg")
    public suspend fun filters(`value`: RemediationFiltersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param argument The filters that will be applied to determine which resources to remediate.
     */
    @JvmName("fbffwqqywevfndlk")
    public suspend fun filters(argument: suspend RemediationFiltersArgsBuilder.() -> Unit) {
        val toBeMapped = RemediationFiltersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param value Determines how many resources to remediate at any given time. Can be used to increase or reduce the pace of the remediation. If not provided, the default parallel deployments value is used.
     */
    @JvmName("kvlldmxmdrwbvplc")
    public suspend fun parallelDeployments(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parallelDeployments = mapped
    }

    /**
     * @param value The resource ID of the policy assignment that should be remediated.
     */
    @JvmName("usgfbhrlibiuknlt")
    public suspend fun policyAssignmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyAssignmentId = mapped
    }

    /**
     * @param value The policy definition reference ID of the individual definition that should be remediated. Required when the policy assignment being remediated assigns a policy set definition.
     */
    @JvmName("seeesbkokggkcytr")
    public suspend fun policyDefinitionReferenceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDefinitionReferenceId = mapped
    }

    /**
     * @param value The name of the remediation.
     */
    @JvmName("qamdpirbjbykpdhq")
    public suspend fun remediationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remediationName = mapped
    }

    /**
     * @param value Determines the max number of resources that can be remediated by the remediation job. If not provided, the default resource count is used.
     */
    @JvmName("mtsdvnvfgcqbmxpa")
    public suspend fun resourceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceCount = mapped
    }

    /**
     * @param value The way resources to remediate are discovered. Defaults to ExistingNonCompliant if not specified.
     */
    @JvmName("nybxltdodbqfnrkj")
    public suspend fun resourceDiscoveryMode(`value`: Either<String, ResourceDiscoveryMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceDiscoveryMode = mapped
    }

    /**
     * @param value The way resources to remediate are discovered. Defaults to ExistingNonCompliant if not specified.
     */
    @JvmName("qthspnhtulkuhpsq")
    public fun resourceDiscoveryMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ResourceDiscoveryMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceDiscoveryMode = mapped
    }

    /**
     * @param value The way resources to remediate are discovered. Defaults to ExistingNonCompliant if not specified.
     */
    @JvmName("svpyasljxocfmxrx")
    public fun resourceDiscoveryMode(`value`: ResourceDiscoveryMode) {
        val toBeMapped = Either.ofRight<String, ResourceDiscoveryMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceDiscoveryMode = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("dlkaehwymkdofpyd")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): RemediationAtResourceArgs = RemediationAtResourceArgs(
        failureThreshold = failureThreshold,
        filters = filters,
        parallelDeployments = parallelDeployments,
        policyAssignmentId = policyAssignmentId,
        policyDefinitionReferenceId = policyDefinitionReferenceId,
        remediationName = remediationName,
        resourceCount = resourceCount,
        resourceDiscoveryMode = resourceDiscoveryMode,
        resourceId = resourceId,
    )
}
