@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.policyinsights.kotlin.inputs

import com.pulumi.azurenative.policyinsights.inputs.AttestationEvidenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A piece of evidence supporting the compliance state set in the attestation.
 * @property description The description for this piece of evidence.
 * @property sourceUri The URI location of the evidence.
 */
public data class AttestationEvidenceArgs(
    public val description: Output<String>? = null,
    public val sourceUri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.policyinsights.inputs.AttestationEvidenceArgs> {
    override fun toJava(): com.pulumi.azurenative.policyinsights.inputs.AttestationEvidenceArgs =
        com.pulumi.azurenative.policyinsights.inputs.AttestationEvidenceArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .sourceUri(sourceUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AttestationEvidenceArgs].
 */
@PulumiTagMarker
public class AttestationEvidenceArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var sourceUri: Output<String>? = null

    /**
     * @param value The description for this piece of evidence.
     */
    @JvmName("fvclcuckfafvjjbo")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The URI location of the evidence.
     */
    @JvmName("bbgiianfaffbuknq")
    public suspend fun sourceUri(`value`: Output<String>) {
        this.sourceUri = value
    }

    /**
     * @param value The description for this piece of evidence.
     */
    @JvmName("scicbucxaghwcmfo")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The URI location of the evidence.
     */
    @JvmName("smmiugcsavvbcorm")
    public suspend fun sourceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceUri = mapped
    }

    internal fun build(): AttestationEvidenceArgs = AttestationEvidenceArgs(
        description = description,
        sourceUri = sourceUri,
    )
}
