@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.policyinsights.kotlin.inputs

import com.pulumi.azurenative.policyinsights.inputs.GetRemediationAtManagementGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property managementGroupId Management group ID.
 * @property managementGroupsNamespace The namespace for Microsoft Management RP; only "Microsoft.Management" is allowed.
 * @property remediationName The name of the remediation.
 */
public data class GetRemediationAtManagementGroupPlainArgs(
    public val managementGroupId: String,
    public val managementGroupsNamespace: String,
    public val remediationName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.policyinsights.inputs.GetRemediationAtManagementGroupPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.policyinsights.inputs.GetRemediationAtManagementGroupPlainArgs =
        com.pulumi.azurenative.policyinsights.inputs.GetRemediationAtManagementGroupPlainArgs.builder()
            .managementGroupId(managementGroupId.let({ args0 -> args0 }))
            .managementGroupsNamespace(managementGroupsNamespace.let({ args0 -> args0 }))
            .remediationName(remediationName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRemediationAtManagementGroupPlainArgs].
 */
@PulumiTagMarker
public class GetRemediationAtManagementGroupPlainArgsBuilder internal constructor() {
    private var managementGroupId: String? = null

    private var managementGroupsNamespace: String? = null

    private var remediationName: String? = null

    /**
     * @param value Management group ID.
     */
    @JvmName("lelrhthpglpmabtb")
    public suspend fun managementGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managementGroupId = mapped
    }

    /**
     * @param value The namespace for Microsoft Management RP; only "Microsoft.Management" is allowed.
     */
    @JvmName("bjbmekpawjdjmypo")
    public suspend fun managementGroupsNamespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managementGroupsNamespace = mapped
    }

    /**
     * @param value The name of the remediation.
     */
    @JvmName("sfdwfvouajfhkouw")
    public suspend fun remediationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.remediationName = mapped
    }

    internal fun build(): GetRemediationAtManagementGroupPlainArgs =
        GetRemediationAtManagementGroupPlainArgs(
            managementGroupId = managementGroupId ?: throw PulumiNullFieldException("managementGroupId"),
            managementGroupsNamespace = managementGroupsNamespace ?: throw
                PulumiNullFieldException("managementGroupsNamespace"),
            remediationName = remediationName ?: throw PulumiNullFieldException("remediationName"),
        )
}
