@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.policyinsights.kotlin.inputs

import com.pulumi.azurenative.policyinsights.inputs.GetRemediationAtSubscriptionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property remediationName The name of the remediation.
 */
public data class GetRemediationAtSubscriptionPlainArgs(
    public val remediationName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.policyinsights.inputs.GetRemediationAtSubscriptionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.policyinsights.inputs.GetRemediationAtSubscriptionPlainArgs =
        com.pulumi.azurenative.policyinsights.inputs.GetRemediationAtSubscriptionPlainArgs.builder()
            .remediationName(remediationName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRemediationAtSubscriptionPlainArgs].
 */
@PulumiTagMarker
public class GetRemediationAtSubscriptionPlainArgsBuilder internal constructor() {
    private var remediationName: String? = null

    /**
     * @param value The name of the remediation.
     */
    @JvmName("nojgqrxkesuqvovn")
    public suspend fun remediationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.remediationName = mapped
    }

    internal fun build(): GetRemediationAtSubscriptionPlainArgs =
        GetRemediationAtSubscriptionPlainArgs(
            remediationName = remediationName ?: throw PulumiNullFieldException("remediationName"),
        )
}
