@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.policyinsights.kotlin.inputs

import com.pulumi.azurenative.policyinsights.inputs.ListRemediationDeploymentsAtManagementGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property managementGroupId Management group ID.
 * @property managementGroupsNamespace The namespace for Microsoft Management RP; only "Microsoft.Management" is allowed.
 * @property remediationName The name of the remediation.
 * @property top Maximum number of records to return.
 */
public data class ListRemediationDeploymentsAtManagementGroupPlainArgs(
    public val managementGroupId: String,
    public val managementGroupsNamespace: String,
    public val remediationName: String,
    public val top: Int? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.policyinsights.inputs.ListRemediationDeploymentsAtManagementGroupPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.policyinsights.inputs.ListRemediationDeploymentsAtManagementGroupPlainArgs =
        com.pulumi.azurenative.policyinsights.inputs.ListRemediationDeploymentsAtManagementGroupPlainArgs.builder()
            .managementGroupId(managementGroupId.let({ args0 -> args0 }))
            .managementGroupsNamespace(managementGroupsNamespace.let({ args0 -> args0 }))
            .remediationName(remediationName.let({ args0 -> args0 }))
            .top(top?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListRemediationDeploymentsAtManagementGroupPlainArgs].
 */
@PulumiTagMarker
public class ListRemediationDeploymentsAtManagementGroupPlainArgsBuilder internal constructor() {
    private var managementGroupId: String? = null

    private var managementGroupsNamespace: String? = null

    private var remediationName: String? = null

    private var top: Int? = null

    /**
     * @param value Management group ID.
     */
    @JvmName("ddujswnngqswubtu")
    public suspend fun managementGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managementGroupId = mapped
    }

    /**
     * @param value The namespace for Microsoft Management RP; only "Microsoft.Management" is allowed.
     */
    @JvmName("wgjqwgmusgpvbiom")
    public suspend fun managementGroupsNamespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managementGroupsNamespace = mapped
    }

    /**
     * @param value The name of the remediation.
     */
    @JvmName("geqhxstkssqvmroe")
    public suspend fun remediationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.remediationName = mapped
    }

    /**
     * @param value Maximum number of records to return.
     */
    @JvmName("vukmylqktrnmjmpl")
    public suspend fun top(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.top = mapped
    }

    internal fun build(): ListRemediationDeploymentsAtManagementGroupPlainArgs =
        ListRemediationDeploymentsAtManagementGroupPlainArgs(
            managementGroupId = managementGroupId ?: throw PulumiNullFieldException("managementGroupId"),
            managementGroupsNamespace = managementGroupsNamespace ?: throw
                PulumiNullFieldException("managementGroupsNamespace"),
            remediationName = remediationName ?: throw PulumiNullFieldException("remediationName"),
            top = top,
        )
}
