@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.policyinsights.kotlin.inputs

import com.pulumi.azurenative.policyinsights.inputs.ListRemediationDeploymentsAtResourcePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property remediationName The name of the remediation.
 * @property resourceId Resource ID.
 * @property top Maximum number of records to return.
 */
public data class ListRemediationDeploymentsAtResourcePlainArgs(
    public val remediationName: String,
    public val resourceId: String,
    public val top: Int? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.policyinsights.inputs.ListRemediationDeploymentsAtResourcePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.policyinsights.inputs.ListRemediationDeploymentsAtResourcePlainArgs =
        com.pulumi.azurenative.policyinsights.inputs.ListRemediationDeploymentsAtResourcePlainArgs.builder()
            .remediationName(remediationName.let({ args0 -> args0 }))
            .resourceId(resourceId.let({ args0 -> args0 }))
            .top(top?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListRemediationDeploymentsAtResourcePlainArgs].
 */
@PulumiTagMarker
public class ListRemediationDeploymentsAtResourcePlainArgsBuilder internal constructor() {
    private var remediationName: String? = null

    private var resourceId: String? = null

    private var top: Int? = null

    /**
     * @param value The name of the remediation.
     */
    @JvmName("lracpncavmgumoux")
    public suspend fun remediationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.remediationName = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("erlsdqsxwlxrgyab")
    public suspend fun resourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceId = mapped
    }

    /**
     * @param value Maximum number of records to return.
     */
    @JvmName("nfjalnqjbxfqwisu")
    public suspend fun top(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.top = mapped
    }

    internal fun build(): ListRemediationDeploymentsAtResourcePlainArgs =
        ListRemediationDeploymentsAtResourcePlainArgs(
            remediationName = remediationName ?: throw PulumiNullFieldException("remediationName"),
            resourceId = resourceId ?: throw PulumiNullFieldException("resourceId"),
            top = top,
        )
}
