@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.policyinsights.kotlin.inputs

import com.pulumi.azurenative.policyinsights.inputs.RemediationFiltersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The filters that will be applied to determine which resources to remediate.
 * @property locations The resource locations that will be remediated.
 */
public data class RemediationFiltersArgs(
    public val locations: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.policyinsights.inputs.RemediationFiltersArgs> {
    override fun toJava(): com.pulumi.azurenative.policyinsights.inputs.RemediationFiltersArgs =
        com.pulumi.azurenative.policyinsights.inputs.RemediationFiltersArgs.builder()
            .locations(locations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [RemediationFiltersArgs].
 */
@PulumiTagMarker
public class RemediationFiltersArgsBuilder internal constructor() {
    private var locations: Output<List<String>>? = null

    /**
     * @param value The resource locations that will be remediated.
     */
    @JvmName("cchbrjcgesstwdgu")
    public suspend fun locations(`value`: Output<List<String>>) {
        this.locations = value
    }

    @JvmName("shggmdvrjcdwplxf")
    public suspend fun locations(vararg values: Output<String>) {
        this.locations = Output.all(values.asList())
    }

    /**
     * @param values The resource locations that will be remediated.
     */
    @JvmName("qecjyrohqrftibiu")
    public suspend fun locations(values: List<Output<String>>) {
        this.locations = Output.all(values)
    }

    /**
     * @param value The resource locations that will be remediated.
     */
    @JvmName("xmoidnshpmsjoxvo")
    public suspend fun locations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param values The resource locations that will be remediated.
     */
    @JvmName("hplprpvtuloowwxi")
    public suspend fun locations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    internal fun build(): RemediationFiltersArgs = RemediationFiltersArgs(
        locations = locations,
    )
}
