@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin

import com.pulumi.azurenative.portal.kotlin.outputs.ConsolePropertiesResponse
import com.pulumi.azurenative.portal.kotlin.outputs.ConsolePropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Console].
 */
@PulumiTagMarker
public class ConsoleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConsoleArgs = ConsoleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConsoleArgsBuilder.() -> Unit) {
        val builder = ConsoleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Console {
        val builtJavaResource = com.pulumi.azurenative.portal.Console(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Console(builtJavaResource)
    }
}

/**
 * Cloud shell console
 * Azure REST API version: 2018-10-01. Prior API version in Azure Native 1.x: 2018-10-01.
 * ## Example Usage
 * ### PutConsole
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var console = new AzureNative.Portal.Console("console", new()
 *     {
 *         ConsoleName = "default",
 *         Properties = new AzureNative.Portal.Inputs.ConsoleCreatePropertiesArgs
 *         {
 *             OsType = "Linux",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/portal/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := portal.NewConsole(ctx, "console", &portal.ConsoleArgs{
 * 			ConsoleName: pulumi.String("default"),
 * 			Properties: &portal.ConsoleCreatePropertiesArgs{
 * 				OsType: pulumi.String("Linux"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.portal.Console;
 * import com.pulumi.azurenative.portal.ConsoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var console = new Console("console", ConsoleArgs.builder()
 *             .consoleName("default")
 *             .properties(Map.of("osType", "Linux"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:portal:Console myresource1 /providers/Microsoft.Portal/consoles/{consoleName}
 * ```
 */
public class Console internal constructor(
    override val javaResource: com.pulumi.azurenative.portal.Console,
) : KotlinCustomResource(javaResource, ConsoleMapper) {
    /**
     * Cloud shell console properties.
     */
    public val properties: Output<ConsolePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
}

public object ConsoleMapper : ResourceMapper<Console> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.portal.Console::class == javaResource::class

    override fun map(javaResource: Resource): Console = Console(
        javaResource as
            com.pulumi.azurenative.portal.Console,
    )
}

/**
 * @see [Console].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Console].
 */
public suspend fun console(name: String, block: suspend ConsoleResourceBuilder.() -> Unit):
    Console {
    val builder = ConsoleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Console].
 * @param name The _unique_ name of the resulting resource.
 */
public fun console(name: String): Console {
    val builder = ConsoleResourceBuilder()
    builder.name(name)
    return builder.build()
}
