@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin

import com.pulumi.azurenative.portal.ConsoleWithLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Cloud shell console
 * Azure REST API version: 2018-10-01. Prior API version in Azure Native 1.x: 2018-10-01.
 * ## Example Usage
 * ### PutConsole
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var consoleWithLocation = new AzureNative.Portal.ConsoleWithLocation("consoleWithLocation", new()
 *     {
 *         ConsoleName = "default",
 *         Location = "eastus",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/portal/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := portal.NewConsoleWithLocation(ctx, "consoleWithLocation", &portal.ConsoleWithLocationArgs{
 * 			ConsoleName: pulumi.String("default"),
 * 			Location:    pulumi.String("eastus"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.portal.ConsoleWithLocation;
 * import com.pulumi.azurenative.portal.ConsoleWithLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var consoleWithLocation = new ConsoleWithLocation("consoleWithLocation", ConsoleWithLocationArgs.builder()
 *             .consoleName("default")
 *             .location("eastus")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:portal:ConsoleWithLocation myresource1 /providers/Microsoft.Portal/locations/{location}/consoles/{consoleName}
 * ```
 * @property consoleName The name of the console
 * @property location The provider location
 */
public data class ConsoleWithLocationArgs(
    public val consoleName: Output<String>? = null,
    public val location: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.portal.ConsoleWithLocationArgs> {
    override fun toJava(): com.pulumi.azurenative.portal.ConsoleWithLocationArgs =
        com.pulumi.azurenative.portal.ConsoleWithLocationArgs.builder()
            .consoleName(consoleName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConsoleWithLocationArgs].
 */
@PulumiTagMarker
public class ConsoleWithLocationArgsBuilder internal constructor() {
    private var consoleName: Output<String>? = null

    private var location: Output<String>? = null

    /**
     * @param value The name of the console
     */
    @JvmName("tmahegckhqivsjlq")
    public suspend fun consoleName(`value`: Output<String>) {
        this.consoleName = value
    }

    /**
     * @param value The provider location
     */
    @JvmName("wyjimxlgqkqalbfa")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the console
     */
    @JvmName("qcwlbrjenjarloyg")
    public suspend fun consoleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consoleName = mapped
    }

    /**
     * @param value The provider location
     */
    @JvmName("wavfupvkgfvensfq")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    internal fun build(): ConsoleWithLocationArgs = ConsoleWithLocationArgs(
        consoleName = consoleName,
        location = location,
    )
}
