@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TenantConfiguration].
 */
@PulumiTagMarker
public class TenantConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TenantConfigurationArgs = TenantConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TenantConfigurationArgsBuilder.() -> Unit) {
        val builder = TenantConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TenantConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.portal.TenantConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TenantConfiguration(builtJavaResource)
    }
}

/**
 * Tenant configuration.
 * Azure REST API version: 2020-09-01-preview. Prior API version in Azure Native 1.x: 2020-09-01-preview.
 * ## Example Usage
 * ### Create or update Tenant configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tenantConfiguration = new AzureNative.Portal.TenantConfiguration("tenantConfiguration", new()
 *     {
 *         ConfigurationName = "default",
 *         EnforcePrivateMarkdownStorage = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/portal/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := portal.NewTenantConfiguration(ctx, "tenantConfiguration", &portal.TenantConfigurationArgs{
 * 			ConfigurationName:             pulumi.String("default"),
 * 			EnforcePrivateMarkdownStorage: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.portal.TenantConfiguration;
 * import com.pulumi.azurenative.portal.TenantConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tenantConfiguration = new TenantConfiguration("tenantConfiguration", TenantConfigurationArgs.builder()
 *             .configurationName("default")
 *             .enforcePrivateMarkdownStorage(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:portal:TenantConfiguration default /providers/Microsoft.Portal/tenantConfigurations/{configurationName}
 * ```
 */
public class TenantConfiguration internal constructor(
    override val javaResource: com.pulumi.azurenative.portal.TenantConfiguration,
) : KotlinCustomResource(javaResource, TenantConfigurationMapper) {
    /**
     * When flag is set to true Markdown tile will require external storage configuration (URI). The inline content configuration will be prohibited.
     */
    public val enforcePrivateMarkdownStorage: Output<Boolean>?
        get() = javaResource.enforcePrivateMarkdownStorage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object TenantConfigurationMapper : ResourceMapper<TenantConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.portal.TenantConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): TenantConfiguration = TenantConfiguration(
        javaResource
            as com.pulumi.azurenative.portal.TenantConfiguration,
    )
}

/**
 * @see [TenantConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TenantConfiguration].
 */
public suspend fun tenantConfiguration(
    name: String,
    block: suspend TenantConfigurationResourceBuilder.() -> Unit,
): TenantConfiguration {
    val builder = TenantConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TenantConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun tenantConfiguration(name: String): TenantConfiguration {
    val builder = TenantConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
