@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin

import com.pulumi.azurenative.portal.kotlin.outputs.UserPropertiesResponse
import com.pulumi.azurenative.portal.kotlin.outputs.UserPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [UserSettings].
 */
@PulumiTagMarker
public class UserSettingsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserSettingsArgs = UserSettingsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserSettingsArgsBuilder.() -> Unit) {
        val builder = UserSettingsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): UserSettings {
        val builtJavaResource = com.pulumi.azurenative.portal.UserSettings(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UserSettings(builtJavaResource)
    }
}

/**
 * Response to get user settings
 * Azure REST API version: 2018-10-01. Prior API version in Azure Native 1.x: 2018-10-01.
 * ## Example Usage
 * ### PutUserSettings
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var userSettings = new AzureNative.Portal.UserSettings("userSettings", new()
 *     {
 *         Properties = new AzureNative.Portal.Inputs.UserPropertiesArgs
 *         {
 *             PreferredLocation = "eastus",
 *             PreferredOsType = "Linux",
 *             PreferredShellType = "bash",
 *             StorageProfile = new AzureNative.Portal.Inputs.StorageProfileArgs
 *             {
 *                 DiskSizeInGB = 5,
 *                 FileShareName = "string",
 *                 StorageAccountResourceId = "string",
 *             },
 *             TerminalSettings = new AzureNative.Portal.Inputs.TerminalSettingsArgs
 *             {
 *                 FontSize = "Medium",
 *                 FontStyle = "Monospace",
 *             },
 *         },
 *         UserSettingsName = "cloudconsole",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/portal/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := portal.NewUserSettings(ctx, "userSettings", &portal.UserSettingsArgs{
 * 			Properties: portal.UserPropertiesResponse{
 * 				PreferredLocation:  pulumi.String("eastus"),
 * 				PreferredOsType:    pulumi.String("Linux"),
 * 				PreferredShellType: pulumi.String("bash"),
 * 				StorageProfile: &portal.StorageProfileArgs{
 * 					DiskSizeInGB:             pulumi.Int(5),
 * 					FileShareName:            pulumi.String("string"),
 * 					StorageAccountResourceId: pulumi.String("string"),
 * 				},
 * 				TerminalSettings: &portal.TerminalSettingsArgs{
 * 					FontSize:  pulumi.String("Medium"),
 * 					FontStyle: pulumi.String("Monospace"),
 * 				},
 * 			},
 * 			UserSettingsName: pulumi.String("cloudconsole"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.portal.UserSettings;
 * import com.pulumi.azurenative.portal.UserSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var userSettings = new UserSettings("userSettings", UserSettingsArgs.builder()
 *             .properties(Map.ofEntries(
 *                 Map.entry("preferredLocation", "eastus"),
 *                 Map.entry("preferredOsType", "Linux"),
 *                 Map.entry("preferredShellType", "bash"),
 *                 Map.entry("storageProfile", Map.ofEntries(
 *                     Map.entry("diskSizeInGB", 5),
 *                     Map.entry("fileShareName", "string"),
 *                     Map.entry("storageAccountResourceId", "string")
 *                 )),
 *                 Map.entry("terminalSettings", Map.ofEntries(
 *                     Map.entry("fontSize", "Medium"),
 *                     Map.entry("fontStyle", "Monospace")
 *                 ))
 *             ))
 *             .userSettingsName("cloudconsole")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:portal:UserSettings myresource1 /providers/Microsoft.Portal/userSettings/{userSettingsName}
 * ```
 */
public class UserSettings internal constructor(
    override val javaResource: com.pulumi.azurenative.portal.UserSettings,
) : KotlinCustomResource(javaResource, UserSettingsMapper) {
    /**
     * The cloud shell user settings properties.
     */
    public val properties: Output<UserPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
}

public object UserSettingsMapper : ResourceMapper<UserSettings> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.portal.UserSettings::class == javaResource::class

    override fun map(javaResource: Resource): UserSettings = UserSettings(
        javaResource as
            com.pulumi.azurenative.portal.UserSettings,
    )
}

/**
 * @see [UserSettings].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserSettings].
 */
public suspend fun userSettings(
    name: String,
    block: suspend UserSettingsResourceBuilder.() -> Unit,
): UserSettings {
    val builder = UserSettingsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserSettings].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userSettings(name: String): UserSettings {
    val builder = UserSettingsResourceBuilder()
    builder.name(name)
    return builder.build()
}
