@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.inputs

import com.pulumi.azurenative.portal.inputs.DashboardPartsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A dashboard part.
 * @property metadata The dashboard part's metadata.
 * @property position The dashboard's part position.
 */
public data class DashboardPartsArgs(
    public val metadata: Output<MarkdownPartMetadataArgs>? = null,
    public val position: Output<DashboardPartsPositionArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.portal.inputs.DashboardPartsArgs> {
    override fun toJava(): com.pulumi.azurenative.portal.inputs.DashboardPartsArgs =
        com.pulumi.azurenative.portal.inputs.DashboardPartsArgs.builder()
            .metadata(metadata?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .position(position.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DashboardPartsArgs].
 */
@PulumiTagMarker
public class DashboardPartsArgsBuilder internal constructor() {
    private var metadata: Output<MarkdownPartMetadataArgs>? = null

    private var position: Output<DashboardPartsPositionArgs>? = null

    /**
     * @param value The dashboard part's metadata.
     */
    @JvmName("yhjrpkcwwrjhubjg")
    public suspend fun metadata(`value`: Output<MarkdownPartMetadataArgs>) {
        this.metadata = value
    }

    /**
     * @param value The dashboard's part position.
     */
    @JvmName("jowuvhctyekmjxyc")
    public suspend fun position(`value`: Output<DashboardPartsPositionArgs>) {
        this.position = value
    }

    /**
     * @param value The dashboard part's metadata.
     */
    @JvmName("qrrtetwsrnfmmnjj")
    public suspend fun metadata(`value`: MarkdownPartMetadataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param argument The dashboard part's metadata.
     */
    @JvmName("uxyueuocmgydserb")
    public suspend fun metadata(argument: suspend MarkdownPartMetadataArgsBuilder.() -> Unit) {
        val toBeMapped = MarkdownPartMetadataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param value The dashboard's part position.
     */
    @JvmName("bnmkweibwnnrbtjr")
    public suspend fun position(`value`: DashboardPartsPositionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.position = mapped
    }

    /**
     * @param argument The dashboard's part position.
     */
    @JvmName("jjtcvjoxpqvomdma")
    public suspend fun position(argument: suspend DashboardPartsPositionArgsBuilder.() -> Unit) {
        val toBeMapped = DashboardPartsPositionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.position = mapped
    }

    internal fun build(): DashboardPartsArgs = DashboardPartsArgs(
        metadata = metadata,
        position = position ?: throw PulumiNullFieldException("position"),
    )
}
