@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.inputs

import com.pulumi.azurenative.portal.inputs.GetConsolePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property consoleName The name of the console
 */
public data class GetConsolePlainArgs(
    public val consoleName: String,
) : ConvertibleToJava<com.pulumi.azurenative.portal.inputs.GetConsolePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.portal.inputs.GetConsolePlainArgs =
        com.pulumi.azurenative.portal.inputs.GetConsolePlainArgs.builder()
            .consoleName(consoleName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConsolePlainArgs].
 */
@PulumiTagMarker
public class GetConsolePlainArgsBuilder internal constructor() {
    private var consoleName: String? = null

    /**
     * @param value The name of the console
     */
    @JvmName("wmsthvdtgrhmydkk")
    public suspend fun consoleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.consoleName = mapped
    }

    internal fun build(): GetConsolePlainArgs = GetConsolePlainArgs(
        consoleName = consoleName ?: throw PulumiNullFieldException("consoleName"),
    )
}
