@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.inputs

import com.pulumi.azurenative.portal.inputs.GetConsoleWithLocationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property consoleName The name of the console
 * @property location The provider location
 */
public data class GetConsoleWithLocationPlainArgs(
    public val consoleName: String,
    public val location: String,
) : ConvertibleToJava<com.pulumi.azurenative.portal.inputs.GetConsoleWithLocationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.portal.inputs.GetConsoleWithLocationPlainArgs =
        com.pulumi.azurenative.portal.inputs.GetConsoleWithLocationPlainArgs.builder()
            .consoleName(consoleName.let({ args0 -> args0 }))
            .location(location.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConsoleWithLocationPlainArgs].
 */
@PulumiTagMarker
public class GetConsoleWithLocationPlainArgsBuilder internal constructor() {
    private var consoleName: String? = null

    private var location: String? = null

    /**
     * @param value The name of the console
     */
    @JvmName("drefejqsxxpsowgu")
    public suspend fun consoleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.consoleName = mapped
    }

    /**
     * @param value The provider location
     */
    @JvmName("rtxpxkmxxgneismj")
    public suspend fun location(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.location = mapped
    }

    internal fun build(): GetConsoleWithLocationPlainArgs = GetConsoleWithLocationPlainArgs(
        consoleName = consoleName ?: throw PulumiNullFieldException("consoleName"),
        location = location ?: throw PulumiNullFieldException("location"),
    )
}
