@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.inputs

import com.pulumi.azurenative.portal.inputs.MarkdownPartMetadataContentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The content of markdown part.
 * @property settings The setting of the content of markdown part.
 */
public data class MarkdownPartMetadataContentArgs(
    public val settings: Output<MarkdownPartMetadataSettingsSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.portal.inputs.MarkdownPartMetadataContentArgs> {
    override fun toJava(): com.pulumi.azurenative.portal.inputs.MarkdownPartMetadataContentArgs =
        com.pulumi.azurenative.portal.inputs.MarkdownPartMetadataContentArgs.builder()
            .settings(settings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [MarkdownPartMetadataContentArgs].
 */
@PulumiTagMarker
public class MarkdownPartMetadataContentArgsBuilder internal constructor() {
    private var settings: Output<MarkdownPartMetadataSettingsSettingsArgs>? = null

    /**
     * @param value The setting of the content of markdown part.
     */
    @JvmName("qtxqbcvelifdbxgf")
    public suspend fun settings(`value`: Output<MarkdownPartMetadataSettingsSettingsArgs>) {
        this.settings = value
    }

    /**
     * @param value The setting of the content of markdown part.
     */
    @JvmName("cnmlwewwnbpwoxaj")
    public suspend fun settings(`value`: MarkdownPartMetadataSettingsSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param argument The setting of the content of markdown part.
     */
    @JvmName("akywtgusovtxdbcc")
    public suspend
    fun settings(argument: suspend MarkdownPartMetadataSettingsSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = MarkdownPartMetadataSettingsSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    internal fun build(): MarkdownPartMetadataContentArgs = MarkdownPartMetadataContentArgs(
        settings = settings,
    )
}
