@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.inputs

import com.pulumi.azurenative.portal.inputs.MarkdownPartMetadataSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Markdown part settings.
 * @property content The content of markdown part.
 */
public data class MarkdownPartMetadataSettingsArgs(
    public val content: Output<MarkdownPartMetadataContentArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.portal.inputs.MarkdownPartMetadataSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.portal.inputs.MarkdownPartMetadataSettingsArgs =
        com.pulumi.azurenative.portal.inputs.MarkdownPartMetadataSettingsArgs.builder()
            .content(content?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [MarkdownPartMetadataSettingsArgs].
 */
@PulumiTagMarker
public class MarkdownPartMetadataSettingsArgsBuilder internal constructor() {
    private var content: Output<MarkdownPartMetadataContentArgs>? = null

    /**
     * @param value The content of markdown part.
     */
    @JvmName("fplrwnaeubohhjgo")
    public suspend fun content(`value`: Output<MarkdownPartMetadataContentArgs>) {
        this.content = value
    }

    /**
     * @param value The content of markdown part.
     */
    @JvmName("evubluamgvhqlfnv")
    public suspend fun content(`value`: MarkdownPartMetadataContentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param argument The content of markdown part.
     */
    @JvmName("ooreqgpjaivuvwjw")
    public suspend fun content(argument: suspend MarkdownPartMetadataContentArgsBuilder.() -> Unit) {
        val toBeMapped = MarkdownPartMetadataContentArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.content = mapped
    }

    internal fun build(): MarkdownPartMetadataSettingsArgs = MarkdownPartMetadataSettingsArgs(
        content = content,
    )
}
