@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.inputs

import com.pulumi.azurenative.portal.inputs.StorageProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The storage profile of the user settings.
 * @property diskSizeInGB Size of file share
 * @property fileShareName Name of the mounted file share. 63 characters or less, lowercase alphabet, numbers, and -
 * @property storageAccountResourceId Full resource ID of storage account.
 */
public data class StorageProfileArgs(
    public val diskSizeInGB: Output<Int>? = null,
    public val fileShareName: Output<String>? = null,
    public val storageAccountResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.portal.inputs.StorageProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.portal.inputs.StorageProfileArgs =
        com.pulumi.azurenative.portal.inputs.StorageProfileArgs.builder()
            .diskSizeInGB(diskSizeInGB?.applyValue({ args0 -> args0 }))
            .fileShareName(fileShareName?.applyValue({ args0 -> args0 }))
            .storageAccountResourceId(storageAccountResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageProfileArgs].
 */
@PulumiTagMarker
public class StorageProfileArgsBuilder internal constructor() {
    private var diskSizeInGB: Output<Int>? = null

    private var fileShareName: Output<String>? = null

    private var storageAccountResourceId: Output<String>? = null

    /**
     * @param value Size of file share
     */
    @JvmName("bebbxtwhepgrvxcv")
    public suspend fun diskSizeInGB(`value`: Output<Int>) {
        this.diskSizeInGB = value
    }

    /**
     * @param value Name of the mounted file share. 63 characters or less, lowercase alphabet, numbers, and -
     */
    @JvmName("puvgkhrypxxkdjwd")
    public suspend fun fileShareName(`value`: Output<String>) {
        this.fileShareName = value
    }

    /**
     * @param value Full resource ID of storage account.
     */
    @JvmName("fdenqyvbubmnvbss")
    public suspend fun storageAccountResourceId(`value`: Output<String>) {
        this.storageAccountResourceId = value
    }

    /**
     * @param value Size of file share
     */
    @JvmName("hveuxwsjdgonwwkt")
    public suspend fun diskSizeInGB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskSizeInGB = mapped
    }

    /**
     * @param value Name of the mounted file share. 63 characters or less, lowercase alphabet, numbers, and -
     */
    @JvmName("ehycpahgmrsbimim")
    public suspend fun fileShareName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileShareName = mapped
    }

    /**
     * @param value Full resource ID of storage account.
     */
    @JvmName("ajedslblangkbsvi")
    public suspend fun storageAccountResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountResourceId = mapped
    }

    internal fun build(): StorageProfileArgs = StorageProfileArgs(
        diskSizeInGB = diskSizeInGB,
        fileShareName = fileShareName,
        storageAccountResourceId = storageAccountResourceId,
    )
}
