@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.inputs

import com.pulumi.azurenative.portal.inputs.TerminalSettingsArgs.builder
import com.pulumi.azurenative.portal.kotlin.enums.FontSize
import com.pulumi.azurenative.portal.kotlin.enums.FontStyle
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Settings for terminal appearance.
 * @property fontSize Size of terminal font.
 * @property fontStyle Style of terminal font.
 */
public data class TerminalSettingsArgs(
    public val fontSize: Output<Either<String, FontSize>>? = null,
    public val fontStyle: Output<Either<String, FontStyle>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.portal.inputs.TerminalSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.portal.inputs.TerminalSettingsArgs =
        com.pulumi.azurenative.portal.inputs.TerminalSettingsArgs.builder()
            .fontSize(
                fontSize?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .fontStyle(
                fontStyle?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [TerminalSettingsArgs].
 */
@PulumiTagMarker
public class TerminalSettingsArgsBuilder internal constructor() {
    private var fontSize: Output<Either<String, FontSize>>? = null

    private var fontStyle: Output<Either<String, FontStyle>>? = null

    /**
     * @param value Size of terminal font.
     */
    @JvmName("tcrlarbqhdhtqspi")
    public suspend fun fontSize(`value`: Output<Either<String, FontSize>>) {
        this.fontSize = value
    }

    /**
     * @param value Style of terminal font.
     */
    @JvmName("sbvpnbektkusdsno")
    public suspend fun fontStyle(`value`: Output<Either<String, FontStyle>>) {
        this.fontStyle = value
    }

    /**
     * @param value Size of terminal font.
     */
    @JvmName("vnkogjtcodpfxknl")
    public suspend fun fontSize(`value`: Either<String, FontSize>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fontSize = mapped
    }

    /**
     * @param value Size of terminal font.
     */
    @JvmName("vbnqsclnbuwbmoxm")
    public fun fontSize(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FontSize>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fontSize = mapped
    }

    /**
     * @param value Size of terminal font.
     */
    @JvmName("yteymcmpmexbbjqi")
    public fun fontSize(`value`: FontSize) {
        val toBeMapped = Either.ofRight<String, FontSize>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fontSize = mapped
    }

    /**
     * @param value Style of terminal font.
     */
    @JvmName("yhdmulxpixwyeqlr")
    public suspend fun fontStyle(`value`: Either<String, FontStyle>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fontStyle = mapped
    }

    /**
     * @param value Style of terminal font.
     */
    @JvmName("eyhwyqwfnemajwgr")
    public fun fontStyle(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FontStyle>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fontStyle = mapped
    }

    /**
     * @param value Style of terminal font.
     */
    @JvmName("dymqmwlsxthmihut")
    public fun fontStyle(`value`: FontStyle) {
        val toBeMapped = Either.ofRight<String, FontStyle>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fontStyle = mapped
    }

    internal fun build(): TerminalSettingsArgs = TerminalSettingsArgs(
        fontSize = fontSize,
        fontStyle = fontStyle,
    )
}
