@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerbi.kotlin

import com.pulumi.azurenative.powerbi.PowerBIResourceArgs.builder
import com.pulumi.azurenative.powerbi.kotlin.inputs.PrivateEndpointConnectionArgs
import com.pulumi.azurenative.powerbi.kotlin.inputs.PrivateEndpointConnectionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2020-06-01. Prior API version in Azure Native 1.x: 2020-06-01.
 * ## Example Usage
 * ### Creates or updates private link service resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var powerBIResource = new AzureNative.PowerBI.PowerBIResource("powerBIResource", new()
 *     {
 *         AzureResourceName = "azureResourceName",
 *         Location = "global",
 *         ResourceGroupName = "resourceGroup",
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *         TenantId = "ac2bc297-8a3e-46f3-972d-87c2b4ae6e2f",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/powerbi/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := powerbi.NewPowerBIResource(ctx, "powerBIResource", &powerbi.PowerBIResourceArgs{
 * 			AzureResourceName: pulumi.String("azureResourceName"),
 * 			Location:          pulumi.String("global"),
 * 			ResourceGroupName: pulumi.String("resourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 			TenantId: pulumi.String("ac2bc297-8a3e-46f3-972d-87c2b4ae6e2f"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.powerbi.PowerBIResource;
 * import com.pulumi.azurenative.powerbi.PowerBIResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var powerBIResource = new PowerBIResource("powerBIResource", PowerBIResourceArgs.builder()
 *             .azureResourceName("azureResourceName")
 *             .location("global")
 *             .resourceGroupName("resourceGroup")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .tenantId("ac2bc297-8a3e-46f3-972d-87c2b4ae6e2f")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:powerbi:PowerBIResource myPrivateLinkServiceResource /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBI/privateLinkServicesForPowerBI/{azureResourceName}
 * ```
 * @property azureResourceName The name of the Azure resource.
 * @property location Specifies the location of the resource.
 * @property privateEndpointConnections Specifies the private endpoint connections of the resource.
 * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
 * @property resourceGroupName The name of the resource group.
 * @property tags Specifies the tags of the resource.
 * @property tenantId Specifies the tenant id of the resource.
 */
public data class PowerBIResourceArgs(
    public val azureResourceName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.powerbi.PowerBIResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.powerbi.PowerBIResourceArgs =
        com.pulumi.azurenative.powerbi.PowerBIResourceArgs.builder()
            .azureResourceName(azureResourceName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .privateEndpointConnections(
                privateEndpointConnections?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PowerBIResourceArgs].
 */
@PulumiTagMarker
public class PowerBIResourceArgsBuilder internal constructor() {
    private var azureResourceName: Output<String>? = null

    private var location: Output<String>? = null

    private var privateEndpointConnections: Output<List<PrivateEndpointConnectionArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value The name of the Azure resource.
     */
    @JvmName("hgnflmynijpyctts")
    public suspend fun azureResourceName(`value`: Output<String>) {
        this.azureResourceName = value
    }

    /**
     * @param value Specifies the location of the resource.
     */
    @JvmName("vydabvjmmkwnvnvl")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Specifies the private endpoint connections of the resource.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("vlaqsfvilxmgrcsa")
    public suspend
    fun privateEndpointConnections(`value`: Output<List<PrivateEndpointConnectionArgs>>) {
        this.privateEndpointConnections = value
    }

    @JvmName("svhpvfpocifhsmht")
    public suspend fun privateEndpointConnections(
        vararg
        values: Output<PrivateEndpointConnectionArgs>,
    ) {
        this.privateEndpointConnections = Output.all(values.asList())
    }

    /**
     * @param values Specifies the private endpoint connections of the resource.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("idsnctadvnpmsvug")
    public suspend
    fun privateEndpointConnections(values: List<Output<PrivateEndpointConnectionArgs>>) {
        this.privateEndpointConnections = Output.all(values)
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("jtynioujxyaooqsk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Specifies the tags of the resource.
     */
    @JvmName("bckacwrfmmwyiyyf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the tenant id of the resource.
     */
    @JvmName("jwegvwjgubujhnpj")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value The name of the Azure resource.
     */
    @JvmName("dakcgambmjtgfhar")
    public suspend fun azureResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureResourceName = mapped
    }

    /**
     * @param value Specifies the location of the resource.
     */
    @JvmName("dxqoifqdcspdmlsh")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Specifies the private endpoint connections of the resource.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("citkjylwovypqmaq")
    public suspend fun privateEndpointConnections(`value`: List<PrivateEndpointConnectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument Specifies the private endpoint connections of the resource.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("jiwoqviqomicptwn")
    public suspend
    fun privateEndpointConnections(argument: List<suspend PrivateEndpointConnectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrivateEndpointConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument Specifies the private endpoint connections of the resource.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("jselentrfkrvlrry")
    public suspend fun privateEndpointConnections(
        vararg
        argument: suspend PrivateEndpointConnectionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PrivateEndpointConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument Specifies the private endpoint connections of the resource.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("jkgytlepkmofdubx")
    public suspend
    fun privateEndpointConnections(argument: suspend PrivateEndpointConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PrivateEndpointConnectionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param values Specifies the private endpoint connections of the resource.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("pltrpypbqqlrdajr")
    public suspend fun privateEndpointConnections(vararg values: PrivateEndpointConnectionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateEndpointConnections = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("gpyahoufjrheyhuy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Specifies the tags of the resource.
     */
    @JvmName("ijleejooyjiwhouw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Specifies the tags of the resource.
     */
    @JvmName("kiefkdtvbqgffavr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies the tenant id of the resource.
     */
    @JvmName("kglfxdicquvutnyj")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): PowerBIResourceArgs = PowerBIResourceArgs(
        azureResourceName = azureResourceName,
        location = location,
        privateEndpointConnections = privateEndpointConnections,
        resourceGroupName = resourceGroupName,
        tags = tags,
        tenantId = tenantId,
    )
}
