@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerbi.kotlin

import com.pulumi.azurenative.powerbi.PowerbiFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.powerbi.PowerbiFunctions.getWorkspaceCollectionPlain
import com.pulumi.azurenative.powerbi.PowerbiFunctions.listWorkspaceCollectionAccessKeysPlain
import com.pulumi.azurenative.powerbi.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.powerbi.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.powerbi.kotlin.inputs.GetWorkspaceCollectionPlainArgs
import com.pulumi.azurenative.powerbi.kotlin.inputs.GetWorkspaceCollectionPlainArgsBuilder
import com.pulumi.azurenative.powerbi.kotlin.inputs.ListWorkspaceCollectionAccessKeysPlainArgs
import com.pulumi.azurenative.powerbi.kotlin.inputs.ListWorkspaceCollectionAccessKeysPlainArgsBuilder
import com.pulumi.azurenative.powerbi.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.powerbi.kotlin.outputs.GetWorkspaceCollectionResult
import com.pulumi.azurenative.powerbi.kotlin.outputs.ListWorkspaceCollectionAccessKeysResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.powerbi.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.powerbi.kotlin.outputs.GetWorkspaceCollectionResult.Companion.toKotlin as getWorkspaceCollectionResultToKotlin
import com.pulumi.azurenative.powerbi.kotlin.outputs.ListWorkspaceCollectionAccessKeysResult.Companion.toKotlin as listWorkspaceCollectionAccessKeysResultToKotlin

public object PowerbiFunctions {
    /**
     * Get a specific private endpoint connection for Power BI by private endpoint name.
     * Azure REST API version: 2020-06-01.
     * @param argument null
     * @return null
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs):
        GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param azureResourceName The name of the Azure resource.
     * @param privateEndpointName The name of the private endpoint.
     * @param resourceGroupName The name of the resource group.
     * @return null
     */
    public suspend fun getPrivateEndpointConnection(
        azureResourceName: String,
        privateEndpointName: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            azureResourceName = azureResourceName,
            privateEndpointName = privateEndpointName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;powerbi&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return null
     */
    public suspend
    fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves an existing Power BI Workspace Collection.
     * Azure REST API version: 2016-01-29.
     * @param argument null
     * @return null
     */
    public suspend fun getWorkspaceCollection(argument: GetWorkspaceCollectionPlainArgs):
        GetWorkspaceCollectionResult =
        getWorkspaceCollectionResultToKotlin(getWorkspaceCollectionPlain(argument.toJava()).await())

    /**
     * @see [getWorkspaceCollection].
     * @param resourceGroupName Azure resource group
     * @param workspaceCollectionName Power BI Embedded Workspace Collection name
     * @return null
     */
    public suspend fun getWorkspaceCollection(
        resourceGroupName: String,
        workspaceCollectionName: String,
    ): GetWorkspaceCollectionResult {
        val argument = GetWorkspaceCollectionPlainArgs(
            resourceGroupName = resourceGroupName,
            workspaceCollectionName = workspaceCollectionName,
        )
        return getWorkspaceCollectionResultToKotlin(getWorkspaceCollectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspaceCollection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;powerbi&#46;kotlin&#46;inputs&#46;GetWorkspaceCollectionPlainArgs].
     * @return null
     */
    public suspend
    fun getWorkspaceCollection(argument: suspend GetWorkspaceCollectionPlainArgsBuilder.() -> Unit):
        GetWorkspaceCollectionResult {
        val builder = GetWorkspaceCollectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceCollectionResultToKotlin(getWorkspaceCollectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves the primary and secondary access keys for the specified Power BI Workspace Collection.
     * Azure REST API version: 2016-01-29.
     * @param argument null
     * @return null
     */
    public suspend
    fun listWorkspaceCollectionAccessKeys(argument: ListWorkspaceCollectionAccessKeysPlainArgs):
        ListWorkspaceCollectionAccessKeysResult =
        listWorkspaceCollectionAccessKeysResultToKotlin(listWorkspaceCollectionAccessKeysPlain(argument.toJava()).await())

    /**
     * @see [listWorkspaceCollectionAccessKeys].
     * @param resourceGroupName Azure resource group
     * @param workspaceCollectionName Power BI Embedded Workspace Collection name
     * @return null
     */
    public suspend fun listWorkspaceCollectionAccessKeys(
        resourceGroupName: String,
        workspaceCollectionName: String,
    ): ListWorkspaceCollectionAccessKeysResult {
        val argument = ListWorkspaceCollectionAccessKeysPlainArgs(
            resourceGroupName = resourceGroupName,
            workspaceCollectionName = workspaceCollectionName,
        )
        return listWorkspaceCollectionAccessKeysResultToKotlin(listWorkspaceCollectionAccessKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listWorkspaceCollectionAccessKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;powerbi&#46;kotlin&#46;inputs&#46;ListWorkspaceCollectionAccessKeysPlainArgs].
     * @return null
     */
    public suspend
    fun listWorkspaceCollectionAccessKeys(argument: suspend ListWorkspaceCollectionAccessKeysPlainArgsBuilder.() -> Unit):
        ListWorkspaceCollectionAccessKeysResult {
        val builder = ListWorkspaceCollectionAccessKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listWorkspaceCollectionAccessKeysResultToKotlin(listWorkspaceCollectionAccessKeysPlain(builtArgument.toJava()).await())
    }
}
