@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerbi.kotlin.inputs

import com.pulumi.azurenative.powerbi.inputs.ListWorkspaceCollectionAccessKeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName Azure resource group
 * @property workspaceCollectionName Power BI Embedded Workspace Collection name
 */
public data class ListWorkspaceCollectionAccessKeysPlainArgs(
    public val resourceGroupName: String,
    public val workspaceCollectionName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.powerbi.inputs.ListWorkspaceCollectionAccessKeysPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.powerbi.inputs.ListWorkspaceCollectionAccessKeysPlainArgs =
        com.pulumi.azurenative.powerbi.inputs.ListWorkspaceCollectionAccessKeysPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceCollectionName(workspaceCollectionName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListWorkspaceCollectionAccessKeysPlainArgs].
 */
@PulumiTagMarker
public class ListWorkspaceCollectionAccessKeysPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var workspaceCollectionName: String? = null

    /**
     * @param value Azure resource group
     */
    @JvmName("sdflmfnpugnfkjnj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Power BI Embedded Workspace Collection name
     */
    @JvmName("telbbmkcqxbilpou")
    public suspend fun workspaceCollectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceCollectionName = mapped
    }

    internal fun build(): ListWorkspaceCollectionAccessKeysPlainArgs =
        ListWorkspaceCollectionAccessKeysPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            workspaceCollectionName = workspaceCollectionName ?: throw
                PulumiNullFieldException("workspaceCollectionName"),
        )
}
