@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerbi.kotlin.inputs

import com.pulumi.azurenative.powerbi.inputs.PrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.powerbi.kotlin.enums.ResourceProvisioningState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property privateEndpoint Specifies the private endpoint.
 * @property privateLinkServiceConnectionState Specifies the connection state.
 * @property provisioningState Provisioning state of the Private Endpoint Connection.
 */
public data class PrivateEndpointConnectionArgs(
    public val privateEndpoint: Output<PrivateEndpointArgs>? = null,
    public val privateLinkServiceConnectionState: Output<ConnectionStateArgs>? = null,
    public val provisioningState: Output<Either<String, ResourceProvisioningState>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.powerbi.inputs.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.powerbi.inputs.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.powerbi.inputs.PrivateEndpointConnectionArgs.builder()
            .privateEndpoint(privateEndpoint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var privateEndpoint: Output<PrivateEndpointArgs>? = null

    private var privateLinkServiceConnectionState: Output<ConnectionStateArgs>? = null

    private var provisioningState: Output<Either<String, ResourceProvisioningState>>? = null

    /**
     * @param value Specifies the private endpoint.
     */
    @JvmName("esxnrddhyyuwwngu")
    public suspend fun privateEndpoint(`value`: Output<PrivateEndpointArgs>) {
        this.privateEndpoint = value
    }

    /**
     * @param value Specifies the connection state.
     */
    @JvmName("lvoasunwhqigfjyu")
    public suspend fun privateLinkServiceConnectionState(`value`: Output<ConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value Provisioning state of the Private Endpoint Connection.
     */
    @JvmName("kpmsbwdnpeeiddyp")
    public suspend fun provisioningState(`value`: Output<Either<String, ResourceProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value Specifies the private endpoint.
     */
    @JvmName("smvpjlvcevdeanur")
    public suspend fun privateEndpoint(`value`: PrivateEndpointArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpoint = mapped
    }

    /**
     * @param argument Specifies the private endpoint.
     */
    @JvmName("tghixtbvdgirqvyp")
    public suspend fun privateEndpoint(argument: suspend PrivateEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateEndpointArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateEndpoint = mapped
    }

    /**
     * @param value Specifies the connection state.
     */
    @JvmName("jfukdbdlnhyyqokq")
    public suspend fun privateLinkServiceConnectionState(`value`: ConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument Specifies the connection state.
     */
    @JvmName("cwpoaegqcuiayenr")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend ConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionStateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value Provisioning state of the Private Endpoint Connection.
     */
    @JvmName("ygdecxmoobfrckwo")
    public suspend fun provisioningState(`value`: Either<String, ResourceProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning state of the Private Endpoint Connection.
     */
    @JvmName("argucgxylwsvxonm")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ResourceProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning state of the Private Endpoint Connection.
     */
    @JvmName("kmdrxwmdmljumojr")
    public fun provisioningState(`value`: ResourceProvisioningState) {
        val toBeMapped = Either.ofRight<String, ResourceProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        privateEndpoint = privateEndpoint,
        privateLinkServiceConnectionState = privateLinkServiceConnectionState,
        provisioningState = provisioningState,
    )
}
