@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerbidedicated.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the generation of the Power BI Embedded capacity. If no value is specified, the default value 'Gen2' is used. [Learn More](https://docs.microsoft.com/power-bi/developer/embedded/power-bi-embedded-generation-2)
 */
public enum class Mode(
    public val javaValue: com.pulumi.azurenative.powerbidedicated.enums.Mode,
) : ConvertibleToJava<com.pulumi.azurenative.powerbidedicated.enums.Mode> {
    Gen1(com.pulumi.azurenative.powerbidedicated.enums.Mode.Gen1),
    Gen2(com.pulumi.azurenative.powerbidedicated.enums.Mode.Gen2),
    ;

    override fun toJava(): com.pulumi.azurenative.powerbidedicated.enums.Mode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.powerbidedicated.enums.Mode): Mode =
            Mode.values().first { it.javaValue == javaType }
    }
}
