@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerbidedicated.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Represents the SKU name and Azure pricing tier for PowerBI Dedicated capacity resource.
 * @property capacity The capacity of the SKU.
 * @property name Name of the SKU level.
 * @property tier The name of the Azure pricing tier to which the SKU applies.
 */
public data class CapacitySkuResponse(
    public val capacity: Int? = null,
    public val name: String,
    public val tier: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.powerbidedicated.outputs.CapacitySkuResponse):
            CapacitySkuResponse = CapacitySkuResponse(
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
