@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerbidedicated.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Represents an instance of an auto scale v-core resource.
 * @property capacityLimit The maximum capacity of an auto scale v-core resource.
 * @property capacityObjectId The object ID of the capacity resource associated with the auto scale v-core resource.
 * @property id An identifier that represents the PowerBI Dedicated resource.
 * @property location Location of the PowerBI Dedicated resource.
 * @property name The name of the PowerBI Dedicated resource.
 * @property provisioningState The current deployment state of an auto scale v-core resource. The provisioningState is to indicate states for resource provisioning.
 * @property sku The SKU of the auto scale v-core resource.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Key-value pairs of additional resource provisioning properties.
 * @property type The type of the PowerBI Dedicated resource.
 */
public data class GetAutoScaleVCoreResult(
    public val capacityLimit: Int? = null,
    public val capacityObjectId: String? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val sku: AutoScaleVCoreSkuResponse,
    public val systemData: SystemDataResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.powerbidedicated.outputs.GetAutoScaleVCoreResult):
            GetAutoScaleVCoreResult = GetAutoScaleVCoreResult(
            capacityLimit = javaType.capacityLimit().map({ args0 -> args0 }).orElse(null),
            capacityObjectId = javaType.capacityObjectId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.powerbidedicated.kotlin.outputs.AutoScaleVCoreSkuResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.powerbidedicated.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
