@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerbidedicated.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Represents an instance of a Dedicated Capacity resource.
 * @property administration A collection of Dedicated capacity administrators
 * @property friendlyName Capacity name
 * @property id An identifier that represents the PowerBI Dedicated resource.
 * @property location Location of the PowerBI Dedicated resource.
 * @property mode Specifies the generation of the Power BI Embedded capacity. If no value is specified, the default value 'Gen2' is used. [Learn More](https://docs.microsoft.com/power-bi/developer/embedded/power-bi-embedded-generation-2)
 * @property name The name of the PowerBI Dedicated resource.
 * @property provisioningState The current deployment state of PowerBI Dedicated resource. The provisioningState is to indicate states for resource provisioning.
 * @property sku The SKU of the PowerBI Dedicated capacity resource.
 * @property state The current state of PowerBI Dedicated resource. The state is to indicate more states outside of resource provisioning.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Key-value pairs of additional resource provisioning properties.
 * @property tenantId Tenant ID for the capacity. Used for creating Pro Plus capacity.
 * @property type The type of the PowerBI Dedicated resource.
 */
public data class GetCapacityDetailsResult(
    public val administration: DedicatedCapacityAdministratorsResponse? = null,
    public val friendlyName: String,
    public val id: String,
    public val location: String,
    public val mode: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val sku: CapacitySkuResponse,
    public val state: String,
    public val systemData: SystemDataResponse? = null,
    public val tags: Map<String, String>? = null,
    public val tenantId: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.powerbidedicated.outputs.GetCapacityDetailsResult):
            GetCapacityDetailsResult = GetCapacityDetailsResult(
            administration = javaType.administration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.powerbidedicated.kotlin.outputs.DedicatedCapacityAdministratorsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            friendlyName = javaType.friendlyName(),
            id = javaType.id(),
            location = javaType.location(),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.powerbidedicated.kotlin.outputs.CapacitySkuResponse.Companion.toKotlin(args0)
            }),
            state = javaType.state(),
            systemData = javaType.systemData().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.powerbidedicated.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tenantId = javaType.tenantId(),
            type = javaType.type(),
        )
    }
}
