@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerplatform.kotlin.inputs

import com.pulumi.azurenative.powerplatform.inputs.PropertiesEncryptionArgs.builder
import com.pulumi.azurenative.powerplatform.kotlin.enums.State
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The encryption settings for a configuration store.
 * @property keyVault Key vault properties.
 * @property state The state of onboarding, which only appears in the response.
 */
public data class PropertiesEncryptionArgs(
    public val keyVault: Output<KeyVaultPropertiesArgs>? = null,
    public val state: Output<Either<String, State>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.powerplatform.inputs.PropertiesEncryptionArgs> {
    override fun toJava(): com.pulumi.azurenative.powerplatform.inputs.PropertiesEncryptionArgs =
        com.pulumi.azurenative.powerplatform.inputs.PropertiesEncryptionArgs.builder()
            .keyVault(keyVault?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PropertiesEncryptionArgs].
 */
@PulumiTagMarker
public class PropertiesEncryptionArgsBuilder internal constructor() {
    private var keyVault: Output<KeyVaultPropertiesArgs>? = null

    private var state: Output<Either<String, State>>? = null

    /**
     * @param value Key vault properties.
     */
    @JvmName("iseslyygvxgnsuhp")
    public suspend fun keyVault(`value`: Output<KeyVaultPropertiesArgs>) {
        this.keyVault = value
    }

    /**
     * @param value The state of onboarding, which only appears in the response.
     */
    @JvmName("kcdakblnynlvsvsb")
    public suspend fun state(`value`: Output<Either<String, State>>) {
        this.state = value
    }

    /**
     * @param value Key vault properties.
     */
    @JvmName("jojokfbpuoimofxx")
    public suspend fun keyVault(`value`: KeyVaultPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVault = mapped
    }

    /**
     * @param argument Key vault properties.
     */
    @JvmName("muoiirchgsckxbwi")
    public suspend fun keyVault(argument: suspend KeyVaultPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyVault = mapped
    }

    /**
     * @param value The state of onboarding, which only appears in the response.
     */
    @JvmName("tjlatvfosgrygovd")
    public suspend fun state(`value`: Either<String, State>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The state of onboarding, which only appears in the response.
     */
    @JvmName("ktprlxyyyckqxiyg")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, State>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The state of onboarding, which only appears in the response.
     */
    @JvmName("lcgvwrxtdbqofjdt")
    public fun state(`value`: State) {
        val toBeMapped = Either.ofRight<String, State>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): PropertiesEncryptionArgs = PropertiesEncryptionArgs(
        keyVault = keyVault,
        state = state,
    )
}
