@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin

import com.pulumi.azurenative.providerhub.kotlin.outputs.NotificationRegistrationResponseProperties
import com.pulumi.azurenative.providerhub.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.providerhub.kotlin.outputs.NotificationRegistrationResponseProperties.Companion.toKotlin as notificationRegistrationResponsePropertiesToKotlin
import com.pulumi.azurenative.providerhub.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [NotificationRegistration].
 */
@PulumiTagMarker
public class NotificationRegistrationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NotificationRegistrationArgs = NotificationRegistrationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NotificationRegistrationArgsBuilder.() -> Unit) {
        val builder = NotificationRegistrationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NotificationRegistration {
        val builtJavaResource =
            com.pulumi.azurenative.providerhub.NotificationRegistration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NotificationRegistration(builtJavaResource)
    }
}

/**
 *  /* /* /*
 * The notification registration definition.
 * Azure REST API version: 2021-09-01-preview. Prior API version in Azure Native 1.x: 2020-11-20.
 * ## Example Usage
 * ### NotificationRegistrations_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var notificationRegistration = new AzureNative.ProviderHub.NotificationRegistration("notificationRegistration", new()
 *     {
 *         NotificationRegistrationName = "fooNotificationRegistration",
 *         Properties = new AzureNative.ProviderHub.Inputs.NotificationRegistrationPropertiesArgs
 *         {
 *             IncludedEvents = new[]
 *             {
 *                 "*/write",
 *                 "Microsoft.Contoso/employees/delete",
 *             },
 *             MessageScope = "RegisteredSubscriptions",
 *             NotificationEndpoints = new[]
 *             {
 *                 new AzureNative.ProviderHub.Inputs.NotificationEndpointArgs
 *                 {
 *                     Locations = new[]
 *                     {
 *                         "",
 *                         "East US",
 *                     },
 *                     NotificationDestination = "/subscriptions/ac6bcfb5-3dc1-491f-95a6-646b89bf3e88/resourceGroups/mgmtexp-eastus/providers/Microsoft.EventHub/namespaces/unitedstates-mgmtexpint/eventhubs/armlinkednotifications",
 *                 },
 *                 new AzureNative.ProviderHub.Inputs.NotificationEndpointArgs
 *                 {
 *                     Locations = new[]
 *                     {
 *                         "North Europe",
 *                     },
 *                     NotificationDestination = "/subscriptions/ac6bcfb5-3dc1-491f-95a6-646b89bf3e88/resourceGroups/mgmtexp-northeurope/providers/Microsoft.EventHub/namespaces/europe-mgmtexpint/eventhubs/armlinkednotifications",
 *                 },
 *             },
 *             NotificationMode = "EventHub",
 *         },
 *         ProviderNamespace = "Microsoft.Contoso",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/providerhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := providerhub.NewNotificationRegistration(ctx, "notificationRegistration", &providerhub.NotificationRegistrationArgs{
 * 			NotificationRegistrationName: pulumi.String("fooNotificationRegistration"),
 * 			Properties: providerhub.NotificationRegistrationResponseProperties{
 * 				IncludedEvents: pulumi.StringArray{
 * 					pulumi.String("*/write"),
 * 					pulumi.String("Microsoft.Contoso/employees/delete"),
 * 				},
 * 				MessageScope: pulumi.String("RegisteredSubscriptions"),
 * 				NotificationEndpoints: providerhub.NotificationEndpointArray{
 * 					&providerhub.NotificationEndpointArgs{
 * 						Locations: pulumi.StringArray{
 * 							pulumi.String(""),
 * 							pulumi.String("East US"),
 * 						},
 * 						NotificationDestination: pulumi.String("/subscriptions/ac6bcfb5-3dc1-491f-95a6-646b89bf3e88/resourceGroups/mgmtexp-eastus/providers/Microsoft.EventHub/namespaces/unitedstates-mgmtexpint/eventhubs/armlinkednotifications"),
 * 					},
 * 					&providerhub.NotificationEndpointArgs{
 * 						Locations: pulumi.StringArray{
 * 							pulumi.String("North Europe"),
 * 						},
 * 						NotificationDestination: pulumi.String("/subscriptions/ac6bcfb5-3dc1-491f-95a6-646b89bf3e88/resourceGroups/mgmtexp-northeurope/providers/Microsoft.EventHub/namespaces/europe-mgmtexpint/eventhubs/armlinkednotifications"),
 * 					},
 * 				},
 * 				NotificationMode: pulumi.String("EventHub"),
 * 			},
 * 			ProviderNamespace: pulumi.String("Microsoft.Contoso"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.providerhub.NotificationRegistration;
 * import com.pulumi.azurenative.providerhub.NotificationRegistrationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var notificationRegistration = new NotificationRegistration("notificationRegistration", NotificationRegistrationArgs.builder()
 *             .notificationRegistrationName("fooNotificationRegistration")
 *             .properties(Map.ofEntries(
 *                 Map.entry("includedEvents",
 *                     "*/write",
 *                     "Microsoft.Contoso/employees/delete"),
 *                 Map.entry("messageScope", "RegisteredSubscriptions"),
 *                 Map.entry("notificationEndpoints",
 *                     Map.ofEntries(
 *                         Map.entry("locations",
 *                             "",
 *                             "East US"),
 *                         Map.entry("notificationDestination", "/subscriptions/ac6bcfb5-3dc1-491f-95a6-646b89bf3e88/resourceGroups/mgmtexp-eastus/providers/Microsoft.EventHub/namespaces/unitedstates-mgmtexpint/eventhubs/armlinkednotifications")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("locations", "North Europe"),
 *                         Map.entry("notificationDestination", "/subscriptions/ac6bcfb5-3dc1-491f-95a6-646b89bf3e88/resourceGroups/mgmtexp-northeurope/providers/Microsoft.EventHub/namespaces/europe-mgmtexpint/eventhubs/armlinkednotifications")
 *                     )),
 *                 Map.entry("notificationMode", "EventHub")
 *             ))
 *             .providerNamespace("Microsoft.Contoso")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:providerhub:NotificationRegistration fooNotificationRegistration /subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/notificationRegistrations/{notificationRegistrationName}
 * ```
 */
public class NotificationRegistration internal constructor(
    override val javaResource: com.pulumi.azurenative.providerhub.NotificationRegistration,
) : KotlinCustomResource(javaResource, NotificationRegistrationMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val properties: Output<NotificationRegistrationResponseProperties>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                notificationRegistrationResponsePropertiesToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NotificationRegistrationMapper : ResourceMapper<NotificationRegistration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.providerhub.NotificationRegistration::class == javaResource::class

    override fun map(javaResource: Resource): NotificationRegistration =
        NotificationRegistration(
            javaResource as
                com.pulumi.azurenative.providerhub.NotificationRegistration,
        )
}

/**
 * @see [NotificationRegistration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NotificationRegistration].
 */
public suspend fun notificationRegistration(
    name: String,
    block: suspend NotificationRegistrationResourceBuilder.() -> Unit,
): NotificationRegistration {
    val builder = NotificationRegistrationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NotificationRegistration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun notificationRegistration(name: String): NotificationRegistration {
    val builder = NotificationRegistrationResourceBuilder()
    builder.name(name)
    return builder.build()
}
