@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin

import com.pulumi.azurenative.providerhub.kotlin.outputs.ProviderRegistrationResponseProperties
import com.pulumi.azurenative.providerhub.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.providerhub.kotlin.outputs.ProviderRegistrationResponseProperties.Companion.toKotlin as providerRegistrationResponsePropertiesToKotlin
import com.pulumi.azurenative.providerhub.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ProviderRegistration].
 */
@PulumiTagMarker
public class ProviderRegistrationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProviderRegistrationArgs = ProviderRegistrationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProviderRegistrationArgsBuilder.() -> Unit) {
        val builder = ProviderRegistrationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ProviderRegistration {
        val builtJavaResource =
            com.pulumi.azurenative.providerhub.ProviderRegistration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ProviderRegistration(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2021-09-01-preview. Prior API version in Azure Native 1.x: 2020-11-20.
 * ## Example Usage
 * ### ProviderRegistrations_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var providerRegistration = new AzureNative.ProviderHub.ProviderRegistration("providerRegistration", new()
 *     {
 *         Properties = new AzureNative.ProviderHub.Inputs.ProviderRegistrationPropertiesArgs
 *         {
 *             Capabilities = new[]
 *             {
 *                 new AzureNative.ProviderHub.Inputs.ResourceProviderCapabilitiesArgs
 *                 {
 *                     Effect = "Allow",
 *                     QuotaId = "CSP_2015-05-01",
 *                 },
 *                 new AzureNative.ProviderHub.Inputs.ResourceProviderCapabilitiesArgs
 *                 {
 *                     Effect = "Allow",
 *                     QuotaId = "CSP_MG_2017-12-01",
 *                 },
 *             },
 *             Management = new AzureNative.ProviderHub.Inputs.ResourceProviderManifestPropertiesManagementArgs
 *             {
 *                 IncidentContactEmail = "helpme@contoso.com",
 *                 IncidentRoutingService = "Contoso Resource Provider",
 *                 IncidentRoutingTeam = "Contoso Triage",
 *                 ServiceTreeInfos = new[]
 *                 {
 *                     new AzureNative.ProviderHub.Inputs.ServiceTreeInfoArgs
 *                     {
 *                         ComponentId = "d1b7d8ba-05e2-48e6-90d6-d781b99c6e69",
 *                         Readiness = "InDevelopment",
 *                         ServiceId = "d1b7d8ba-05e2-48e6-90d6-d781b99c6e69",
 *                     },
 *                 },
 *             },
 *             ProviderType = "Internal",
 *             ProviderVersion = "2.0",
 *         },
 *         ProviderNamespace = "Microsoft.Contoso",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/providerhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := providerhub.NewProviderRegistration(ctx, "providerRegistration", &providerhub.ProviderRegistrationArgs{
 * Properties: providerhub.ProviderRegistrationResponseProperties{
 * Capabilities: providerhub.ResourceProviderCapabilitiesArray{
 * &providerhub.ResourceProviderCapabilitiesArgs{
 * Effect: pulumi.String("Allow"),
 * QuotaId: pulumi.String("CSP_2015-05-01"),
 * },
 * &providerhub.ResourceProviderCapabilitiesArgs{
 * Effect: pulumi.String("Allow"),
 * QuotaId: pulumi.String("CSP_MG_2017-12-01"),
 * },
 * },
 * Management: interface{}{
 * IncidentContactEmail: pulumi.String("helpme@contoso.com"),
 * IncidentRoutingService: pulumi.String("Contoso Resource Provider"),
 * IncidentRoutingTeam: pulumi.String("Contoso Triage"),
 * ServiceTreeInfos: providerhub.ServiceTreeInfoArray{
 * &providerhub.ServiceTreeInfoArgs{
 * ComponentId: pulumi.String("d1b7d8ba-05e2-48e6-90d6-d781b99c6e69"),
 * Readiness: pulumi.String("InDevelopment"),
 * ServiceId: pulumi.String("d1b7d8ba-05e2-48e6-90d6-d781b99c6e69"),
 * },
 * },
 * },
 * ProviderType: pulumi.String("Internal"),
 * ProviderVersion: pulumi.String("2.0"),
 * },
 * ProviderNamespace: pulumi.String("Microsoft.Contoso"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.providerhub.ProviderRegistration;
 * import com.pulumi.azurenative.providerhub.ProviderRegistrationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var providerRegistration = new ProviderRegistration("providerRegistration", ProviderRegistrationArgs.builder()
 *             .properties(Map.ofEntries(
 *                 Map.entry("capabilities",
 *                     Map.ofEntries(
 *                         Map.entry("effect", "Allow"),
 *                         Map.entry("quotaId", "CSP_2015-05-01")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("effect", "Allow"),
 *                         Map.entry("quotaId", "CSP_MG_2017-12-01")
 *                     )),
 *                 Map.entry("management", Map.ofEntries(
 *                     Map.entry("incidentContactEmail", "helpme@contoso.com"),
 *                     Map.entry("incidentRoutingService", "Contoso Resource Provider"),
 *                     Map.entry("incidentRoutingTeam", "Contoso Triage"),
 *                     Map.entry("serviceTreeInfos", Map.ofEntries(
 *                         Map.entry("componentId", "d1b7d8ba-05e2-48e6-90d6-d781b99c6e69"),
 *                         Map.entry("readiness", "InDevelopment"),
 *                         Map.entry("serviceId", "d1b7d8ba-05e2-48e6-90d6-d781b99c6e69")
 *                     ))
 *                 )),
 *                 Map.entry("providerType", "Internal"),
 *                 Map.entry("providerVersion", "2.0")
 *             ))
 *             .providerNamespace("Microsoft.Contoso")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:providerhub:ProviderRegistration myresource1 /subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}
 * ```
 */
public class ProviderRegistration internal constructor(
    override val javaResource: com.pulumi.azurenative.providerhub.ProviderRegistration,
) : KotlinCustomResource(javaResource, ProviderRegistrationMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val properties: Output<ProviderRegistrationResponseProperties>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                providerRegistrationResponsePropertiesToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ProviderRegistrationMapper : ResourceMapper<ProviderRegistration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.providerhub.ProviderRegistration::class == javaResource::class

    override fun map(javaResource: Resource): ProviderRegistration = ProviderRegistration(
        javaResource
            as com.pulumi.azurenative.providerhub.ProviderRegistration,
    )
}

/**
 * @see [ProviderRegistration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProviderRegistration].
 */
public suspend fun providerRegistration(
    name: String,
    block: suspend ProviderRegistrationResourceBuilder.() -> Unit,
): ProviderRegistration {
    val builder = ProviderRegistrationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProviderRegistration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun providerRegistration(name: String): ProviderRegistration {
    val builder = ProviderRegistrationResourceBuilder()
    builder.name(name)
    return builder.build()
}
