@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.DefaultRolloutPropertiesSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property canary
 * @property expeditedRollout
 * @property highTraffic
 * @property lowTraffic
 * @property mediumTraffic
 * @property providerRegistration
 * @property resourceTypeRegistrations
 * @property restOfTheWorldGroupOne
 * @property restOfTheWorldGroupTwo
 */
public data class DefaultRolloutPropertiesSpecificationArgs(
    public val canary: Output<DefaultRolloutSpecificationCanaryArgs>? = null,
    public val expeditedRollout: Output<DefaultRolloutSpecificationExpeditedRolloutArgs>? = null,
    public val highTraffic: Output<DefaultRolloutSpecificationHighTrafficArgs>? = null,
    public val lowTraffic: Output<DefaultRolloutSpecificationLowTrafficArgs>? = null,
    public val mediumTraffic: Output<DefaultRolloutSpecificationMediumTrafficArgs>? = null,
    public val providerRegistration: Output<DefaultRolloutSpecificationProviderRegistrationArgs>? =
        null,
    public val resourceTypeRegistrations: Output<List<ResourceTypeRegistrationArgs>>? = null,
    public val restOfTheWorldGroupOne: Output<DefaultRolloutSpecificationRestOfTheWorldGroupOneArgs>? =
        null,
    public val restOfTheWorldGroupTwo: Output<DefaultRolloutSpecificationRestOfTheWorldGroupTwoArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.DefaultRolloutPropertiesSpecificationArgs> {
    override fun toJava():
        com.pulumi.azurenative.providerhub.inputs.DefaultRolloutPropertiesSpecificationArgs =
        com.pulumi.azurenative.providerhub.inputs.DefaultRolloutPropertiesSpecificationArgs.builder()
            .canary(canary?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .expeditedRollout(expeditedRollout?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .highTraffic(highTraffic?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .lowTraffic(lowTraffic?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .mediumTraffic(mediumTraffic?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .providerRegistration(
                providerRegistration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceTypeRegistrations(
                resourceTypeRegistrations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .restOfTheWorldGroupOne(
                restOfTheWorldGroupOne?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .restOfTheWorldGroupTwo(
                restOfTheWorldGroupTwo?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DefaultRolloutPropertiesSpecificationArgs].
 */
@PulumiTagMarker
public class DefaultRolloutPropertiesSpecificationArgsBuilder internal constructor() {
    private var canary: Output<DefaultRolloutSpecificationCanaryArgs>? = null

    private var expeditedRollout: Output<DefaultRolloutSpecificationExpeditedRolloutArgs>? = null

    private var highTraffic: Output<DefaultRolloutSpecificationHighTrafficArgs>? = null

    private var lowTraffic: Output<DefaultRolloutSpecificationLowTrafficArgs>? = null

    private var mediumTraffic: Output<DefaultRolloutSpecificationMediumTrafficArgs>? = null

    private var providerRegistration: Output<DefaultRolloutSpecificationProviderRegistrationArgs>? =
        null

    private var resourceTypeRegistrations: Output<List<ResourceTypeRegistrationArgs>>? = null

    private var restOfTheWorldGroupOne: Output<DefaultRolloutSpecificationRestOfTheWorldGroupOneArgs>? =
        null

    private var restOfTheWorldGroupTwo: Output<DefaultRolloutSpecificationRestOfTheWorldGroupTwoArgs>? =
        null

    /**
     * @param value
     */
    @JvmName("rjyvyxcacnngyvjf")
    public suspend fun canary(`value`: Output<DefaultRolloutSpecificationCanaryArgs>) {
        this.canary = value
    }

    /**
     * @param value
     */
    @JvmName("sjddolggkaxgwddh")
    public suspend
    fun expeditedRollout(`value`: Output<DefaultRolloutSpecificationExpeditedRolloutArgs>) {
        this.expeditedRollout = value
    }

    /**
     * @param value
     */
    @JvmName("vefovtpvoibcwbch")
    public suspend fun highTraffic(`value`: Output<DefaultRolloutSpecificationHighTrafficArgs>) {
        this.highTraffic = value
    }

    /**
     * @param value
     */
    @JvmName("dsfkmctuucykrbrb")
    public suspend fun lowTraffic(`value`: Output<DefaultRolloutSpecificationLowTrafficArgs>) {
        this.lowTraffic = value
    }

    /**
     * @param value
     */
    @JvmName("irqjsspvorrvpdsq")
    public suspend fun mediumTraffic(`value`: Output<DefaultRolloutSpecificationMediumTrafficArgs>) {
        this.mediumTraffic = value
    }

    /**
     * @param value
     */
    @JvmName("botfarcddfgmgntq")
    public suspend
    fun providerRegistration(`value`: Output<DefaultRolloutSpecificationProviderRegistrationArgs>) {
        this.providerRegistration = value
    }

    /**
     * @param value
     */
    @JvmName("nbskoexhhudeoyrv")
    public suspend
    fun resourceTypeRegistrations(`value`: Output<List<ResourceTypeRegistrationArgs>>) {
        this.resourceTypeRegistrations = value
    }

    @JvmName("okhwwuqdgsfmyeft")
    public suspend fun resourceTypeRegistrations(
        vararg
        values: Output<ResourceTypeRegistrationArgs>,
    ) {
        this.resourceTypeRegistrations = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("iciysuslntljwmwc")
    public suspend fun resourceTypeRegistrations(values: List<Output<ResourceTypeRegistrationArgs>>) {
        this.resourceTypeRegistrations = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("epbyvhxtfmawijnv")
    public suspend
    fun restOfTheWorldGroupOne(`value`: Output<DefaultRolloutSpecificationRestOfTheWorldGroupOneArgs>) {
        this.restOfTheWorldGroupOne = value
    }

    /**
     * @param value
     */
    @JvmName("admesmufauwhbggg")
    public suspend
    fun restOfTheWorldGroupTwo(`value`: Output<DefaultRolloutSpecificationRestOfTheWorldGroupTwoArgs>) {
        this.restOfTheWorldGroupTwo = value
    }

    /**
     * @param value
     */
    @JvmName("ypqotbmuevwetkcc")
    public suspend fun canary(`value`: DefaultRolloutSpecificationCanaryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.canary = mapped
    }

    /**
     * @param argument
     */
    @JvmName("kyfpslwchbttewor")
    public suspend
    fun canary(argument: suspend DefaultRolloutSpecificationCanaryArgsBuilder.() -> Unit) {
        val toBeMapped = DefaultRolloutSpecificationCanaryArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.canary = mapped
    }

    /**
     * @param value
     */
    @JvmName("iygdfgpcthaojgux")
    public suspend fun expeditedRollout(`value`: DefaultRolloutSpecificationExpeditedRolloutArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expeditedRollout = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gefmorrditcjstnm")
    public suspend
    fun expeditedRollout(argument: suspend DefaultRolloutSpecificationExpeditedRolloutArgsBuilder.() -> Unit) {
        val toBeMapped = DefaultRolloutSpecificationExpeditedRolloutArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.expeditedRollout = mapped
    }

    /**
     * @param value
     */
    @JvmName("ihplclgdoslqgxyg")
    public suspend fun highTraffic(`value`: DefaultRolloutSpecificationHighTrafficArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.highTraffic = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dwpkhgflhofbowlf")
    public suspend
    fun highTraffic(argument: suspend DefaultRolloutSpecificationHighTrafficArgsBuilder.() -> Unit) {
        val toBeMapped = DefaultRolloutSpecificationHighTrafficArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.highTraffic = mapped
    }

    /**
     * @param value
     */
    @JvmName("kkiwvdxmevvuqbyk")
    public suspend fun lowTraffic(`value`: DefaultRolloutSpecificationLowTrafficArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lowTraffic = mapped
    }

    /**
     * @param argument
     */
    @JvmName("byfbujmsuxjqdhea")
    public suspend
    fun lowTraffic(argument: suspend DefaultRolloutSpecificationLowTrafficArgsBuilder.() -> Unit) {
        val toBeMapped = DefaultRolloutSpecificationLowTrafficArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.lowTraffic = mapped
    }

    /**
     * @param value
     */
    @JvmName("aifhjqxdahaqtuyb")
    public suspend fun mediumTraffic(`value`: DefaultRolloutSpecificationMediumTrafficArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mediumTraffic = mapped
    }

    /**
     * @param argument
     */
    @JvmName("peavbtsvjfuowlqh")
    public suspend
    fun mediumTraffic(argument: suspend DefaultRolloutSpecificationMediumTrafficArgsBuilder.() -> Unit) {
        val toBeMapped = DefaultRolloutSpecificationMediumTrafficArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.mediumTraffic = mapped
    }

    /**
     * @param value
     */
    @JvmName("foqvbchcjrcwvrqv")
    public suspend
    fun providerRegistration(`value`: DefaultRolloutSpecificationProviderRegistrationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerRegistration = mapped
    }

    /**
     * @param argument
     */
    @JvmName("grmasbgrjcqfgltv")
    public suspend
    fun providerRegistration(argument: suspend DefaultRolloutSpecificationProviderRegistrationArgsBuilder.() -> Unit) {
        val toBeMapped = DefaultRolloutSpecificationProviderRegistrationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.providerRegistration = mapped
    }

    /**
     * @param value
     */
    @JvmName("mpbmhteugxujudrk")
    public suspend fun resourceTypeRegistrations(`value`: List<ResourceTypeRegistrationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTypeRegistrations = mapped
    }

    /**
     * @param argument
     */
    @JvmName("tliuldammeasvgcr")
    public suspend
    fun resourceTypeRegistrations(argument: List<suspend ResourceTypeRegistrationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceTypeRegistrationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceTypeRegistrations = mapped
    }

    /**
     * @param argument
     */
    @JvmName("tgfpmcgekbkyaxib")
    public suspend fun resourceTypeRegistrations(
        vararg
        argument: suspend ResourceTypeRegistrationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ResourceTypeRegistrationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceTypeRegistrations = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dnefamrbqqxcsfdr")
    public suspend
    fun resourceTypeRegistrations(argument: suspend ResourceTypeRegistrationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ResourceTypeRegistrationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceTypeRegistrations = mapped
    }

    /**
     * @param values
     */
    @JvmName("igupfaomicnfmbmh")
    public suspend fun resourceTypeRegistrations(vararg values: ResourceTypeRegistrationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTypeRegistrations = mapped
    }

    /**
     * @param value
     */
    @JvmName("yehrbdtiqbtdlkbh")
    public suspend
    fun restOfTheWorldGroupOne(`value`: DefaultRolloutSpecificationRestOfTheWorldGroupOneArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restOfTheWorldGroupOne = mapped
    }

    /**
     * @param argument
     */
    @JvmName("omggmsbamxidohpf")
    public suspend
    fun restOfTheWorldGroupOne(argument: suspend DefaultRolloutSpecificationRestOfTheWorldGroupOneArgsBuilder.() -> Unit) {
        val toBeMapped = DefaultRolloutSpecificationRestOfTheWorldGroupOneArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.restOfTheWorldGroupOne = mapped
    }

    /**
     * @param value
     */
    @JvmName("qvpheqcelxatyaus")
    public suspend
    fun restOfTheWorldGroupTwo(`value`: DefaultRolloutSpecificationRestOfTheWorldGroupTwoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restOfTheWorldGroupTwo = mapped
    }

    /**
     * @param argument
     */
    @JvmName("exvshururrruvvpj")
    public suspend
    fun restOfTheWorldGroupTwo(argument: suspend DefaultRolloutSpecificationRestOfTheWorldGroupTwoArgsBuilder.() -> Unit) {
        val toBeMapped = DefaultRolloutSpecificationRestOfTheWorldGroupTwoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.restOfTheWorldGroupTwo = mapped
    }

    internal fun build(): DefaultRolloutPropertiesSpecificationArgs =
        DefaultRolloutPropertiesSpecificationArgs(
            canary = canary,
            expeditedRollout = expeditedRollout,
            highTraffic = highTraffic,
            lowTraffic = lowTraffic,
            mediumTraffic = mediumTraffic,
            providerRegistration = providerRegistration,
            resourceTypeRegistrations = resourceTypeRegistrations,
            restOfTheWorldGroupOne = restOfTheWorldGroupOne,
            restOfTheWorldGroupTwo = restOfTheWorldGroupTwo,
        )
}
