@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.DefaultRolloutPropertiesStatusArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.enums.SubscriptionReregistrationResult
import com.pulumi.azurenative.providerhub.kotlin.enums.TrafficRegionCategory
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property completedRegions
 * @property failedOrSkippedRegions
 * @property nextTrafficRegion
 * @property nextTrafficRegionScheduledTime
 * @property subscriptionReregistrationResult
 */
public data class DefaultRolloutPropertiesStatusArgs(
    public val completedRegions: Output<List<String>>? = null,
    public val failedOrSkippedRegions: Output<Map<String, ExtendedErrorInfoArgs>>? = null,
    public val nextTrafficRegion: Output<Either<String, TrafficRegionCategory>>? = null,
    public val nextTrafficRegionScheduledTime: Output<String>? = null,
    public val subscriptionReregistrationResult:
    Output<Either<String, SubscriptionReregistrationResult>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.DefaultRolloutPropertiesStatusArgs> {
    override fun toJava():
        com.pulumi.azurenative.providerhub.inputs.DefaultRolloutPropertiesStatusArgs =
        com.pulumi.azurenative.providerhub.inputs.DefaultRolloutPropertiesStatusArgs.builder()
            .completedRegions(completedRegions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .failedOrSkippedRegions(
                failedOrSkippedRegions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .nextTrafficRegion(
                nextTrafficRegion?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .nextTrafficRegionScheduledTime(nextTrafficRegionScheduledTime?.applyValue({ args0 -> args0 }))
            .subscriptionReregistrationResult(
                subscriptionReregistrationResult?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [DefaultRolloutPropertiesStatusArgs].
 */
@PulumiTagMarker
public class DefaultRolloutPropertiesStatusArgsBuilder internal constructor() {
    private var completedRegions: Output<List<String>>? = null

    private var failedOrSkippedRegions: Output<Map<String, ExtendedErrorInfoArgs>>? = null

    private var nextTrafficRegion: Output<Either<String, TrafficRegionCategory>>? = null

    private var nextTrafficRegionScheduledTime: Output<String>? = null

    private var subscriptionReregistrationResult:
        Output<Either<String, SubscriptionReregistrationResult>>? = null

    /**
     * @param value
     */
    @JvmName("ftfcepsuhlyvtylq")
    public suspend fun completedRegions(`value`: Output<List<String>>) {
        this.completedRegions = value
    }

    @JvmName("wlmtbuecbrimckrd")
    public suspend fun completedRegions(vararg values: Output<String>) {
        this.completedRegions = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("matreehnugltntgr")
    public suspend fun completedRegions(values: List<Output<String>>) {
        this.completedRegions = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("vvjirsbvaqicshto")
    public suspend fun failedOrSkippedRegions(`value`: Output<Map<String, ExtendedErrorInfoArgs>>) {
        this.failedOrSkippedRegions = value
    }

    /**
     * @param value
     */
    @JvmName("avhmclwwpitdtymi")
    public suspend fun nextTrafficRegion(`value`: Output<Either<String, TrafficRegionCategory>>) {
        this.nextTrafficRegion = value
    }

    /**
     * @param value
     */
    @JvmName("osedxtegdfrqkswx")
    public suspend fun nextTrafficRegionScheduledTime(`value`: Output<String>) {
        this.nextTrafficRegionScheduledTime = value
    }

    /**
     * @param value
     */
    @JvmName("lftrlgbamtnusunw")
    public suspend
    fun subscriptionReregistrationResult(`value`: Output<Either<String, SubscriptionReregistrationResult>>) {
        this.subscriptionReregistrationResult = value
    }

    /**
     * @param value
     */
    @JvmName("xabccdfhvlrqbiwt")
    public suspend fun completedRegions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.completedRegions = mapped
    }

    /**
     * @param values
     */
    @JvmName("dlhvocnclfjsbwaj")
    public suspend fun completedRegions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.completedRegions = mapped
    }

    /**
     * @param value
     */
    @JvmName("lcodffjckndagvsn")
    public suspend fun failedOrSkippedRegions(`value`: Map<String, ExtendedErrorInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failedOrSkippedRegions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xbwhjibudlyqayhn")
    public suspend fun failedOrSkippedRegions(
        vararg
        argument: Pair<String, suspend ExtendedErrorInfoArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ExtendedErrorInfoArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.failedOrSkippedRegions = mapped
    }

    /**
     * @param values
     */
    @JvmName("utcpvkaiagmxylqm")
    public fun failedOrSkippedRegions(vararg values: Pair<String, ExtendedErrorInfoArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failedOrSkippedRegions = mapped
    }

    /**
     * @param value
     */
    @JvmName("hnrhomdhkxrgpixj")
    public suspend fun nextTrafficRegion(`value`: Either<String, TrafficRegionCategory>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nextTrafficRegion = mapped
    }

    /**
     * @param value
     */
    @JvmName("aitfgrwpixtekray")
    public fun nextTrafficRegion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TrafficRegionCategory>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nextTrafficRegion = mapped
    }

    /**
     * @param value
     */
    @JvmName("dtmnwhesgaxpwice")
    public fun nextTrafficRegion(`value`: TrafficRegionCategory) {
        val toBeMapped = Either.ofRight<String, TrafficRegionCategory>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nextTrafficRegion = mapped
    }

    /**
     * @param value
     */
    @JvmName("kotymbncdtdaoxis")
    public suspend fun nextTrafficRegionScheduledTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nextTrafficRegionScheduledTime = mapped
    }

    /**
     * @param value
     */
    @JvmName("plmxophpkineoees")
    public suspend
    fun subscriptionReregistrationResult(`value`: Either<String, SubscriptionReregistrationResult>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionReregistrationResult = mapped
    }

    /**
     * @param value
     */
    @JvmName("kxayqrhjrppgyhce")
    public fun subscriptionReregistrationResult(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SubscriptionReregistrationResult>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subscriptionReregistrationResult = mapped
    }

    /**
     * @param value
     */
    @JvmName("vingtwwvsjmolodw")
    public fun subscriptionReregistrationResult(`value`: SubscriptionReregistrationResult) {
        val toBeMapped = Either.ofRight<String, SubscriptionReregistrationResult>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subscriptionReregistrationResult = mapped
    }

    internal fun build(): DefaultRolloutPropertiesStatusArgs = DefaultRolloutPropertiesStatusArgs(
        completedRegions = completedRegions,
        failedOrSkippedRegions = failedOrSkippedRegions,
        nextTrafficRegion = nextTrafficRegion,
        nextTrafficRegionScheduledTime = nextTrafficRegionScheduledTime,
        subscriptionReregistrationResult = subscriptionReregistrationResult,
    )
}
