@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.DefaultRolloutSpecificationLowTrafficArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property regions
 * @property waitDuration
 */
public data class DefaultRolloutSpecificationLowTrafficArgs(
    public val regions: Output<List<String>>? = null,
    public val waitDuration: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.DefaultRolloutSpecificationLowTrafficArgs> {
    override fun toJava():
        com.pulumi.azurenative.providerhub.inputs.DefaultRolloutSpecificationLowTrafficArgs =
        com.pulumi.azurenative.providerhub.inputs.DefaultRolloutSpecificationLowTrafficArgs.builder()
            .regions(regions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .waitDuration(waitDuration?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefaultRolloutSpecificationLowTrafficArgs].
 */
@PulumiTagMarker
public class DefaultRolloutSpecificationLowTrafficArgsBuilder internal constructor() {
    private var regions: Output<List<String>>? = null

    private var waitDuration: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("gwcfqngynsgmoetm")
    public suspend fun regions(`value`: Output<List<String>>) {
        this.regions = value
    }

    @JvmName("jhldfbjoepotvthi")
    public suspend fun regions(vararg values: Output<String>) {
        this.regions = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("sjjvombgccuggurs")
    public suspend fun regions(values: List<Output<String>>) {
        this.regions = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("fsgnytspruiixqqo")
    public suspend fun waitDuration(`value`: Output<String>) {
        this.waitDuration = value
    }

    /**
     * @param value
     */
    @JvmName("owvjqnfyieqisfsy")
    public suspend fun regions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    /**
     * @param values
     */
    @JvmName("mjpvwgjoknjjgych")
    public suspend fun regions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    /**
     * @param value
     */
    @JvmName("qwitqrhyheebtusw")
    public suspend fun waitDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.waitDuration = mapped
    }

    internal fun build(): DefaultRolloutSpecificationLowTrafficArgs =
        DefaultRolloutSpecificationLowTrafficArgs(
            regions = regions,
            waitDuration = waitDuration,
        )
}
