@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.GetSkusNestedResourceTypeSecondPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property nestedResourceTypeFirst The first child resource type.
 * @property nestedResourceTypeSecond The second child resource type.
 * @property providerNamespace The name of the resource provider hosted within ProviderHub.
 * @property resourceType The resource type.
 * @property sku The SKU.
 */
public data class GetSkusNestedResourceTypeSecondPlainArgs(
    public val nestedResourceTypeFirst: String,
    public val nestedResourceTypeSecond: String,
    public val providerNamespace: String,
    public val resourceType: String,
    public val sku: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.GetSkusNestedResourceTypeSecondPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.providerhub.inputs.GetSkusNestedResourceTypeSecondPlainArgs =
        com.pulumi.azurenative.providerhub.inputs.GetSkusNestedResourceTypeSecondPlainArgs.builder()
            .nestedResourceTypeFirst(nestedResourceTypeFirst.let({ args0 -> args0 }))
            .nestedResourceTypeSecond(nestedResourceTypeSecond.let({ args0 -> args0 }))
            .providerNamespace(providerNamespace.let({ args0 -> args0 }))
            .resourceType(resourceType.let({ args0 -> args0 }))
            .sku(sku.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSkusNestedResourceTypeSecondPlainArgs].
 */
@PulumiTagMarker
public class GetSkusNestedResourceTypeSecondPlainArgsBuilder internal constructor() {
    private var nestedResourceTypeFirst: String? = null

    private var nestedResourceTypeSecond: String? = null

    private var providerNamespace: String? = null

    private var resourceType: String? = null

    private var sku: String? = null

    /**
     * @param value The first child resource type.
     */
    @JvmName("ehttjbbdehvppixp")
    public suspend fun nestedResourceTypeFirst(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.nestedResourceTypeFirst = mapped
    }

    /**
     * @param value The second child resource type.
     */
    @JvmName("syvtsffbdwmpdhmq")
    public suspend fun nestedResourceTypeSecond(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.nestedResourceTypeSecond = mapped
    }

    /**
     * @param value The name of the resource provider hosted within ProviderHub.
     */
    @JvmName("sknmmncwaqfmnhwo")
    public suspend fun providerNamespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.providerNamespace = mapped
    }

    /**
     * @param value The resource type.
     */
    @JvmName("neggkawqujueuaou")
    public suspend fun resourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceType = mapped
    }

    /**
     * @param value The SKU.
     */
    @JvmName("klkrvkelrttrorag")
    public suspend fun sku(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sku = mapped
    }

    internal fun build(): GetSkusNestedResourceTypeSecondPlainArgs =
        GetSkusNestedResourceTypeSecondPlainArgs(
            nestedResourceTypeFirst = nestedResourceTypeFirst ?: throw
                PulumiNullFieldException("nestedResourceTypeFirst"),
            nestedResourceTypeSecond = nestedResourceTypeSecond ?: throw
                PulumiNullFieldException("nestedResourceTypeSecond"),
            providerNamespace = providerNamespace ?: throw PulumiNullFieldException("providerNamespace"),
            resourceType = resourceType ?: throw PulumiNullFieldException("resourceType"),
            sku = sku ?: throw PulumiNullFieldException("sku"),
        )
}
