@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.LinkedAccessCheckArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property actionName
 * @property linkedAction
 * @property linkedActionVerb
 * @property linkedProperty
 * @property linkedType
 */
public data class LinkedAccessCheckArgs(
    public val actionName: Output<String>? = null,
    public val linkedAction: Output<String>? = null,
    public val linkedActionVerb: Output<String>? = null,
    public val linkedProperty: Output<String>? = null,
    public val linkedType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.LinkedAccessCheckArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.LinkedAccessCheckArgs =
        com.pulumi.azurenative.providerhub.inputs.LinkedAccessCheckArgs.builder()
            .actionName(actionName?.applyValue({ args0 -> args0 }))
            .linkedAction(linkedAction?.applyValue({ args0 -> args0 }))
            .linkedActionVerb(linkedActionVerb?.applyValue({ args0 -> args0 }))
            .linkedProperty(linkedProperty?.applyValue({ args0 -> args0 }))
            .linkedType(linkedType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LinkedAccessCheckArgs].
 */
@PulumiTagMarker
public class LinkedAccessCheckArgsBuilder internal constructor() {
    private var actionName: Output<String>? = null

    private var linkedAction: Output<String>? = null

    private var linkedActionVerb: Output<String>? = null

    private var linkedProperty: Output<String>? = null

    private var linkedType: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("kmdybjiicdecbpmn")
    public suspend fun actionName(`value`: Output<String>) {
        this.actionName = value
    }

    /**
     * @param value
     */
    @JvmName("wlophjqipuhkewsw")
    public suspend fun linkedAction(`value`: Output<String>) {
        this.linkedAction = value
    }

    /**
     * @param value
     */
    @JvmName("pgobwlhhwbjhhptq")
    public suspend fun linkedActionVerb(`value`: Output<String>) {
        this.linkedActionVerb = value
    }

    /**
     * @param value
     */
    @JvmName("okexvjbilamnutio")
    public suspend fun linkedProperty(`value`: Output<String>) {
        this.linkedProperty = value
    }

    /**
     * @param value
     */
    @JvmName("vayyqubydpddrefu")
    public suspend fun linkedType(`value`: Output<String>) {
        this.linkedType = value
    }

    /**
     * @param value
     */
    @JvmName("bcamypbgvsytkgqg")
    public suspend fun actionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionName = mapped
    }

    /**
     * @param value
     */
    @JvmName("fbhuyqmldeaqcmwl")
    public suspend fun linkedAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedAction = mapped
    }

    /**
     * @param value
     */
    @JvmName("ejljiibrjwyxdmue")
    public suspend fun linkedActionVerb(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedActionVerb = mapped
    }

    /**
     * @param value
     */
    @JvmName("nlcduttbkuqlppac")
    public suspend fun linkedProperty(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedProperty = mapped
    }

    /**
     * @param value
     */
    @JvmName("ptnpxciidwrtibhm")
    public suspend fun linkedType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedType = mapped
    }

    internal fun build(): LinkedAccessCheckArgs = LinkedAccessCheckArgs(
        actionName = actionName,
        linkedAction = linkedAction,
        linkedActionVerb = linkedActionVerb,
        linkedProperty = linkedProperty,
        linkedType = linkedType,
    )
}
