@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.OpenApiValidationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property allowNoncompliantCollectionResponse Indicates whether a non compliance response is allowed for a LIST call
 */
public data class OpenApiValidationArgs(
    public val allowNoncompliantCollectionResponse: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.OpenApiValidationArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.OpenApiValidationArgs =
        com.pulumi.azurenative.providerhub.inputs.OpenApiValidationArgs.builder()
            .allowNoncompliantCollectionResponse(
                allowNoncompliantCollectionResponse?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [OpenApiValidationArgs].
 */
@PulumiTagMarker
public class OpenApiValidationArgsBuilder internal constructor() {
    private var allowNoncompliantCollectionResponse: Output<Boolean>? = null

    /**
     * @param value Indicates whether a non compliance response is allowed for a LIST call
     */
    @JvmName("pdpbgyjubqwafysi")
    public suspend fun allowNoncompliantCollectionResponse(`value`: Output<Boolean>) {
        this.allowNoncompliantCollectionResponse = value
    }

    /**
     * @param value Indicates whether a non compliance response is allowed for a LIST call
     */
    @JvmName("hwpbbkvfvvlwtbar")
    public suspend fun allowNoncompliantCollectionResponse(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowNoncompliantCollectionResponse = mapped
    }

    internal fun build(): OpenApiValidationArgs = OpenApiValidationArgs(
        allowNoncompliantCollectionResponse = allowNoncompliantCollectionResponse,
    )
}
