@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ProviderHubMetadataProviderAuthenticationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allowedAudiences
 */
public data class ProviderHubMetadataProviderAuthenticationArgs(
    public val allowedAudiences: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ProviderHubMetadataProviderAuthenticationArgs> {
    override fun toJava():
        com.pulumi.azurenative.providerhub.inputs.ProviderHubMetadataProviderAuthenticationArgs =
        com.pulumi.azurenative.providerhub.inputs.ProviderHubMetadataProviderAuthenticationArgs.builder()
            .allowedAudiences(allowedAudiences.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ProviderHubMetadataProviderAuthenticationArgs].
 */
@PulumiTagMarker
public class ProviderHubMetadataProviderAuthenticationArgsBuilder internal constructor() {
    private var allowedAudiences: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("tyamdklpoxlctjjh")
    public suspend fun allowedAudiences(`value`: Output<List<String>>) {
        this.allowedAudiences = value
    }

    @JvmName("qslhemljoefeytyy")
    public suspend fun allowedAudiences(vararg values: Output<String>) {
        this.allowedAudiences = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ampsqwletuaktqif")
    public suspend fun allowedAudiences(values: List<Output<String>>) {
        this.allowedAudiences = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("dkuyorxodndhfusm")
    public suspend fun allowedAudiences(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedAudiences = mapped
    }

    /**
     * @param values
     */
    @JvmName("bupbbcyrqbtaphcj")
    public suspend fun allowedAudiences(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedAudiences = mapped
    }

    internal fun build(): ProviderHubMetadataProviderAuthenticationArgs =
        ProviderHubMetadataProviderAuthenticationArgs(
            allowedAudiences = allowedAudiences ?: throw PulumiNullFieldException("allowedAudiences"),
        )
}
