@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ResourceProviderManifestPropertiesProviderAuthenticationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allowedAudiences
 */
public data class ResourceProviderManifestPropertiesProviderAuthenticationArgs(
    public val allowedAudiences: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ResourceProviderManifestPropertiesProviderAuthenticationArgs> {
    override fun toJava():
        com.pulumi.azurenative.providerhub.inputs.ResourceProviderManifestPropertiesProviderAuthenticationArgs =
        com.pulumi.azurenative.providerhub.inputs.ResourceProviderManifestPropertiesProviderAuthenticationArgs.builder()
            .allowedAudiences(allowedAudiences.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ResourceProviderManifestPropertiesProviderAuthenticationArgs].
 */
@PulumiTagMarker
public class ResourceProviderManifestPropertiesProviderAuthenticationArgsBuilder internal
constructor() {
    private var allowedAudiences: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("tjyjskxxsthjewpn")
    public suspend fun allowedAudiences(`value`: Output<List<String>>) {
        this.allowedAudiences = value
    }

    @JvmName("wxukhvgnyfmniwdn")
    public suspend fun allowedAudiences(vararg values: Output<String>) {
        this.allowedAudiences = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("jwjyfgdtrqtygpnh")
    public suspend fun allowedAudiences(values: List<Output<String>>) {
        this.allowedAudiences = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("hthegfjvtomblnnt")
    public suspend fun allowedAudiences(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedAudiences = mapped
    }

    /**
     * @param values
     */
    @JvmName("qhqaisgwfayilxse")
    public suspend fun allowedAudiences(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedAudiences = mapped
    }

    internal fun build(): ResourceProviderManifestPropertiesProviderAuthenticationArgs =
        ResourceProviderManifestPropertiesProviderAuthenticationArgs(
            allowedAudiences = allowedAudiences ?: throw PulumiNullFieldException("allowedAudiences"),
        )
}
