@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ResourceTypeEndpointArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.enums.EndpointType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property apiVersions
 * @property enabled
 * @property endpointType
 * @property extensions
 * @property featuresRule
 * @property locations
 * @property requiredFeatures
 * @property timeout
 */
public data class ResourceTypeEndpointArgs(
    public val apiVersions: Output<List<String>>? = null,
    public val enabled: Output<Boolean>? = null,
    public val endpointType: Output<Either<String, EndpointType>>? = null,
    public val extensions: Output<List<ResourceTypeExtensionArgs>>? = null,
    public val featuresRule: Output<ResourceTypeEndpointFeaturesRuleArgs>? = null,
    public val locations: Output<List<String>>? = null,
    public val requiredFeatures: Output<List<String>>? = null,
    public val timeout: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ResourceTypeEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.ResourceTypeEndpointArgs =
        com.pulumi.azurenative.providerhub.inputs.ResourceTypeEndpointArgs.builder()
            .apiVersions(apiVersions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .endpointType(
                endpointType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .extensions(
                extensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .featuresRule(featuresRule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .locations(locations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .requiredFeatures(requiredFeatures?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .timeout(timeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceTypeEndpointArgs].
 */
@PulumiTagMarker
public class ResourceTypeEndpointArgsBuilder internal constructor() {
    private var apiVersions: Output<List<String>>? = null

    private var enabled: Output<Boolean>? = null

    private var endpointType: Output<Either<String, EndpointType>>? = null

    private var extensions: Output<List<ResourceTypeExtensionArgs>>? = null

    private var featuresRule: Output<ResourceTypeEndpointFeaturesRuleArgs>? = null

    private var locations: Output<List<String>>? = null

    private var requiredFeatures: Output<List<String>>? = null

    private var timeout: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("fpuamawtlsrpymfl")
    public suspend fun apiVersions(`value`: Output<List<String>>) {
        this.apiVersions = value
    }

    @JvmName("vdygpyovvarqwkeh")
    public suspend fun apiVersions(vararg values: Output<String>) {
        this.apiVersions = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("xyaaxiryimlbhwwo")
    public suspend fun apiVersions(values: List<Output<String>>) {
        this.apiVersions = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("dgcvcvljsoufxjhb")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value
     */
    @JvmName("nomntjktlxspltke")
    public suspend fun endpointType(`value`: Output<Either<String, EndpointType>>) {
        this.endpointType = value
    }

    /**
     * @param value
     */
    @JvmName("gqtvhssbxckhtjfx")
    public suspend fun extensions(`value`: Output<List<ResourceTypeExtensionArgs>>) {
        this.extensions = value
    }

    @JvmName("dkwudgtlkfdtfddr")
    public suspend fun extensions(vararg values: Output<ResourceTypeExtensionArgs>) {
        this.extensions = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ksdxufldkhivgkvy")
    public suspend fun extensions(values: List<Output<ResourceTypeExtensionArgs>>) {
        this.extensions = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("rxlkrelsmtyfirtq")
    public suspend fun featuresRule(`value`: Output<ResourceTypeEndpointFeaturesRuleArgs>) {
        this.featuresRule = value
    }

    /**
     * @param value
     */
    @JvmName("syeqbbbwbansojhs")
    public suspend fun locations(`value`: Output<List<String>>) {
        this.locations = value
    }

    @JvmName("wimnmteurpgdefth")
    public suspend fun locations(vararg values: Output<String>) {
        this.locations = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("qxduexsbxohvvprx")
    public suspend fun locations(values: List<Output<String>>) {
        this.locations = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("uvflbhkvoakwcngg")
    public suspend fun requiredFeatures(`value`: Output<List<String>>) {
        this.requiredFeatures = value
    }

    @JvmName("txdsnkgslkmoinnc")
    public suspend fun requiredFeatures(vararg values: Output<String>) {
        this.requiredFeatures = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("kawvyekjvtwualsa")
    public suspend fun requiredFeatures(values: List<Output<String>>) {
        this.requiredFeatures = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("flxxcnpkstjrnxyi")
    public suspend fun timeout(`value`: Output<String>) {
        this.timeout = value
    }

    /**
     * @param value
     */
    @JvmName("mqdmqyatdcqplgfg")
    public suspend fun apiVersions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiVersions = mapped
    }

    /**
     * @param values
     */
    @JvmName("alxpmdsgkjgnamnw")
    public suspend fun apiVersions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apiVersions = mapped
    }

    /**
     * @param value
     */
    @JvmName("xvylkmunpwkkqpwh")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value
     */
    @JvmName("drcmrrqvgwqwmkon")
    public suspend fun endpointType(`value`: Either<String, EndpointType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value
     */
    @JvmName("ymfvrsgftusclpvv")
    public fun endpointType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EndpointType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value
     */
    @JvmName("cedmovpuoyamklgh")
    public fun endpointType(`value`: EndpointType) {
        val toBeMapped = Either.ofRight<String, EndpointType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value
     */
    @JvmName("cvfokqekpdmnando")
    public suspend fun extensions(`value`: List<ResourceTypeExtensionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("yhnwnwtdxoujhwda")
    public suspend
    fun extensions(argument: List<suspend ResourceTypeExtensionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceTypeExtensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.extensions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xbptqllwdryumlii")
    public suspend fun extensions(
        vararg
        argument: suspend ResourceTypeExtensionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ResourceTypeExtensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.extensions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("vvbrwafmktwnykmf")
    public suspend fun extensions(argument: suspend ResourceTypeExtensionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceTypeExtensionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.extensions = mapped
    }

    /**
     * @param values
     */
    @JvmName("txricplnvibiepbe")
    public suspend fun extensions(vararg values: ResourceTypeExtensionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.extensions = mapped
    }

    /**
     * @param value
     */
    @JvmName("tyyikdufrfqynuir")
    public suspend fun featuresRule(`value`: ResourceTypeEndpointFeaturesRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.featuresRule = mapped
    }

    /**
     * @param argument
     */
    @JvmName("kdnyomyskxjxpjeu")
    public suspend
    fun featuresRule(argument: suspend ResourceTypeEndpointFeaturesRuleArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceTypeEndpointFeaturesRuleArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.featuresRule = mapped
    }

    /**
     * @param value
     */
    @JvmName("vdaxcvmxmcxbydrm")
    public suspend fun locations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param values
     */
    @JvmName("tyqjhwbllbpsmrxb")
    public suspend fun locations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param value
     */
    @JvmName("ftyccspahqrayukq")
    public suspend fun requiredFeatures(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiredFeatures = mapped
    }

    /**
     * @param values
     */
    @JvmName("maetxuhsbvbsqkrq")
    public suspend fun requiredFeatures(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requiredFeatures = mapped
    }

    /**
     * @param value
     */
    @JvmName("ubbnpmlukaxordvx")
    public suspend fun timeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    internal fun build(): ResourceTypeEndpointArgs = ResourceTypeEndpointArgs(
        apiVersions = apiVersions,
        enabled = enabled,
        endpointType = endpointType,
        extensions = extensions,
        featuresRule = featuresRule,
        locations = locations,
        requiredFeatures = requiredFeatures,
        timeout = timeout,
    )
}
