@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.enums.ProvisioningState
import com.pulumi.azurenative.providerhub.kotlin.enums.Regionality
import com.pulumi.azurenative.providerhub.kotlin.enums.ResourceDeletionPolicy
import com.pulumi.azurenative.providerhub.kotlin.enums.RoutingType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property allowedUnauthorizedActions
 * @property authorizationActionMappings
 * @property checkNameAvailabilitySpecifications
 * @property defaultApiVersion
 * @property disallowedActionVerbs
 * @property enableAsyncOperation
 * @property enableThirdPartyS2S
 * @property endpoints
 * @property extendedLocations
 * @property extensionOptions
 * @property featuresRule
 * @property identityManagement
 * @property isPureProxy
 * @property linkedAccessChecks
 * @property loggingRules
 * @property management
 * @property marketplaceType
 * @property openApiConfiguration
 * @property provisioningState The provisioned state of the resource.
 * @property regionality
 * @property requestHeaderOptions
 * @property requiredFeatures
 * @property resourceConcurrencyControlOptions
 * @property resourceDeletionPolicy
 * @property resourceGraphConfiguration
 * @property resourceMovePolicy
 * @property routingType
 * @property serviceTreeInfos
 * @property subscriptionLifecycleNotificationSpecifications
 * @property subscriptionStateRules
 * @property swaggerSpecifications
 * @property templateDeploymentOptions
 * @property throttlingRules
 */
public data class ResourceTypeRegistrationPropertiesArgs(
    public val allowedUnauthorizedActions: Output<List<String>>? = null,
    public val authorizationActionMappings: Output<List<AuthorizationActionMappingArgs>>? = null,
    public val checkNameAvailabilitySpecifications:
    Output<ResourceTypeRegistrationPropertiesCheckNameAvailabilitySpecificationsArgs>? = null,
    public val defaultApiVersion: Output<String>? = null,
    public val disallowedActionVerbs: Output<List<String>>? = null,
    public val enableAsyncOperation: Output<Boolean>? = null,
    public val enableThirdPartyS2S: Output<Boolean>? = null,
    public val endpoints: Output<List<ResourceTypeEndpointArgs>>? = null,
    public val extendedLocations: Output<List<ExtendedLocationOptionsArgs>>? = null,
    public val extensionOptions: Output<ResourceTypeRegistrationPropertiesExtensionOptionsArgs>? =
        null,
    public val featuresRule: Output<ResourceTypeRegistrationPropertiesFeaturesRuleArgs>? = null,
    public val identityManagement: Output<ResourceTypeRegistrationPropertiesIdentityManagementArgs>? =
        null,
    public val isPureProxy: Output<Boolean>? = null,
    public val linkedAccessChecks: Output<List<LinkedAccessCheckArgs>>? = null,
    public val loggingRules: Output<List<LoggingRuleArgs>>? = null,
    public val management: Output<ResourceTypeRegistrationPropertiesManagementArgs>? = null,
    public val marketplaceType: Output<String>? = null,
    public val openApiConfiguration: Output<OpenApiConfigurationArgs>? = null,
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
    public val regionality: Output<Either<String, Regionality>>? = null,
    public val requestHeaderOptions:
    Output<ResourceTypeRegistrationPropertiesRequestHeaderOptionsArgs>? = null,
    public val requiredFeatures: Output<List<String>>? = null,
    public val resourceConcurrencyControlOptions:
    Output<Map<String, ResourceConcurrencyControlOptionArgs>>? = null,
    public val resourceDeletionPolicy: Output<Either<String, ResourceDeletionPolicy>>? = null,
    public val resourceGraphConfiguration:
    Output<ResourceTypeRegistrationPropertiesResourceGraphConfigurationArgs>? = null,
    public val resourceMovePolicy: Output<ResourceTypeRegistrationPropertiesResourceMovePolicyArgs>? =
        null,
    public val routingType: Output<Either<String, RoutingType>>? = null,
    public val serviceTreeInfos: Output<List<ServiceTreeInfoArgs>>? = null,
    public val subscriptionLifecycleNotificationSpecifications:
    Output<ResourceTypeRegistrationPropertiesSubscriptionLifecycleNotificationSpecificationsArgs>? =
        null,
    public val subscriptionStateRules: Output<List<SubscriptionStateRuleArgs>>? = null,
    public val swaggerSpecifications: Output<List<SwaggerSpecificationArgs>>? = null,
    public val templateDeploymentOptions:
    Output<ResourceTypeRegistrationPropertiesTemplateDeploymentOptionsArgs>? = null,
    public val throttlingRules: Output<List<ThrottlingRuleArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesArgs =
        com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesArgs.builder()
            .allowedUnauthorizedActions(
                allowedUnauthorizedActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .authorizationActionMappings(
                authorizationActionMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .checkNameAvailabilitySpecifications(
                checkNameAvailabilitySpecifications?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .defaultApiVersion(defaultApiVersion?.applyValue({ args0 -> args0 }))
            .disallowedActionVerbs(disallowedActionVerbs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .enableAsyncOperation(enableAsyncOperation?.applyValue({ args0 -> args0 }))
            .enableThirdPartyS2S(enableThirdPartyS2S?.applyValue({ args0 -> args0 }))
            .endpoints(
                endpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .extendedLocations(
                extendedLocations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .extensionOptions(extensionOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .featuresRule(featuresRule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identityManagement(
                identityManagement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .isPureProxy(isPureProxy?.applyValue({ args0 -> args0 }))
            .linkedAccessChecks(
                linkedAccessChecks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .loggingRules(
                loggingRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .management(management?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .marketplaceType(marketplaceType?.applyValue({ args0 -> args0 }))
            .openApiConfiguration(
                openApiConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .regionality(
                regionality?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .requestHeaderOptions(
                requestHeaderOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .requiredFeatures(requiredFeatures?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceConcurrencyControlOptions(
                resourceConcurrencyControlOptions?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.key.to(args0.value.let({ args0 -> args0.toJava() })) }).toMap()
                }),
            )
            .resourceDeletionPolicy(
                resourceDeletionPolicy?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceGraphConfiguration(
                resourceGraphConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceMovePolicy(
                resourceMovePolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .routingType(
                routingType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .serviceTreeInfos(
                serviceTreeInfos?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .subscriptionLifecycleNotificationSpecifications(
                subscriptionLifecycleNotificationSpecifications?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .subscriptionStateRules(
                subscriptionStateRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .swaggerSpecifications(
                swaggerSpecifications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .templateDeploymentOptions(
                templateDeploymentOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .throttlingRules(
                throttlingRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ResourceTypeRegistrationPropertiesArgs].
 */
@PulumiTagMarker
public class ResourceTypeRegistrationPropertiesArgsBuilder internal constructor() {
    private var allowedUnauthorizedActions: Output<List<String>>? = null

    private var authorizationActionMappings: Output<List<AuthorizationActionMappingArgs>>? = null

    private var checkNameAvailabilitySpecifications:
        Output<ResourceTypeRegistrationPropertiesCheckNameAvailabilitySpecificationsArgs>? = null

    private var defaultApiVersion: Output<String>? = null

    private var disallowedActionVerbs: Output<List<String>>? = null

    private var enableAsyncOperation: Output<Boolean>? = null

    private var enableThirdPartyS2S: Output<Boolean>? = null

    private var endpoints: Output<List<ResourceTypeEndpointArgs>>? = null

    private var extendedLocations: Output<List<ExtendedLocationOptionsArgs>>? = null

    private var extensionOptions: Output<ResourceTypeRegistrationPropertiesExtensionOptionsArgs>? =
        null

    private var featuresRule: Output<ResourceTypeRegistrationPropertiesFeaturesRuleArgs>? = null

    private var identityManagement: Output<ResourceTypeRegistrationPropertiesIdentityManagementArgs>? =
        null

    private var isPureProxy: Output<Boolean>? = null

    private var linkedAccessChecks: Output<List<LinkedAccessCheckArgs>>? = null

    private var loggingRules: Output<List<LoggingRuleArgs>>? = null

    private var management: Output<ResourceTypeRegistrationPropertiesManagementArgs>? = null

    private var marketplaceType: Output<String>? = null

    private var openApiConfiguration: Output<OpenApiConfigurationArgs>? = null

    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    private var regionality: Output<Either<String, Regionality>>? = null

    private var requestHeaderOptions:
        Output<ResourceTypeRegistrationPropertiesRequestHeaderOptionsArgs>? = null

    private var requiredFeatures: Output<List<String>>? = null

    private var resourceConcurrencyControlOptions:
        Output<Map<String, ResourceConcurrencyControlOptionArgs>>? = null

    private var resourceDeletionPolicy: Output<Either<String, ResourceDeletionPolicy>>? = null

    private var resourceGraphConfiguration:
        Output<ResourceTypeRegistrationPropertiesResourceGraphConfigurationArgs>? = null

    private var resourceMovePolicy: Output<ResourceTypeRegistrationPropertiesResourceMovePolicyArgs>? =
        null

    private var routingType: Output<Either<String, RoutingType>>? = null

    private var serviceTreeInfos: Output<List<ServiceTreeInfoArgs>>? = null

    private var subscriptionLifecycleNotificationSpecifications:
        Output<ResourceTypeRegistrationPropertiesSubscriptionLifecycleNotificationSpecificationsArgs>? =
        null

    private var subscriptionStateRules: Output<List<SubscriptionStateRuleArgs>>? = null

    private var swaggerSpecifications: Output<List<SwaggerSpecificationArgs>>? = null

    private var templateDeploymentOptions:
        Output<ResourceTypeRegistrationPropertiesTemplateDeploymentOptionsArgs>? = null

    private var throttlingRules: Output<List<ThrottlingRuleArgs>>? = null

    /**
     * @param value
     */
    @JvmName("tmssgdnewxpebphx")
    public suspend fun allowedUnauthorizedActions(`value`: Output<List<String>>) {
        this.allowedUnauthorizedActions = value
    }

    @JvmName("rgibagkypbwibdaa")
    public suspend fun allowedUnauthorizedActions(vararg values: Output<String>) {
        this.allowedUnauthorizedActions = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("bxrddexebafkwkie")
    public suspend fun allowedUnauthorizedActions(values: List<Output<String>>) {
        this.allowedUnauthorizedActions = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ckpxxkvjftqbhwdk")
    public suspend
    fun authorizationActionMappings(`value`: Output<List<AuthorizationActionMappingArgs>>) {
        this.authorizationActionMappings = value
    }

    @JvmName("njmxeqrqxoplnmro")
    public suspend fun authorizationActionMappings(
        vararg
        values: Output<AuthorizationActionMappingArgs>,
    ) {
        this.authorizationActionMappings = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("gcjcaenakvnhfoqf")
    public suspend
    fun authorizationActionMappings(values: List<Output<AuthorizationActionMappingArgs>>) {
        this.authorizationActionMappings = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("pqiwseqswcbibjhk")
    public suspend
    fun checkNameAvailabilitySpecifications(`value`: Output<ResourceTypeRegistrationPropertiesCheckNameAvailabilitySpecificationsArgs>) {
        this.checkNameAvailabilitySpecifications = value
    }

    /**
     * @param value
     */
    @JvmName("dgocrljymbuiphgu")
    public suspend fun defaultApiVersion(`value`: Output<String>) {
        this.defaultApiVersion = value
    }

    /**
     * @param value
     */
    @JvmName("tsoymrndvgdophtp")
    public suspend fun disallowedActionVerbs(`value`: Output<List<String>>) {
        this.disallowedActionVerbs = value
    }

    @JvmName("tpeluphdiyngrxse")
    public suspend fun disallowedActionVerbs(vararg values: Output<String>) {
        this.disallowedActionVerbs = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("evqxnxmxrbgwuqqk")
    public suspend fun disallowedActionVerbs(values: List<Output<String>>) {
        this.disallowedActionVerbs = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("aailaccydwsriphr")
    public suspend fun enableAsyncOperation(`value`: Output<Boolean>) {
        this.enableAsyncOperation = value
    }

    /**
     * @param value
     */
    @JvmName("uyddcycoathqgsix")
    public suspend fun enableThirdPartyS2S(`value`: Output<Boolean>) {
        this.enableThirdPartyS2S = value
    }

    /**
     * @param value
     */
    @JvmName("oksnebcspcecyppt")
    public suspend fun endpoints(`value`: Output<List<ResourceTypeEndpointArgs>>) {
        this.endpoints = value
    }

    @JvmName("cikmwjawagjilymf")
    public suspend fun endpoints(vararg values: Output<ResourceTypeEndpointArgs>) {
        this.endpoints = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("asjwninkhbaoyxju")
    public suspend fun endpoints(values: List<Output<ResourceTypeEndpointArgs>>) {
        this.endpoints = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("chworvdjcbnjctpy")
    public suspend fun extendedLocations(`value`: Output<List<ExtendedLocationOptionsArgs>>) {
        this.extendedLocations = value
    }

    @JvmName("gxpulbfuvfppeyti")
    public suspend fun extendedLocations(vararg values: Output<ExtendedLocationOptionsArgs>) {
        this.extendedLocations = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("mhjsaomabjvvlris")
    public suspend fun extendedLocations(values: List<Output<ExtendedLocationOptionsArgs>>) {
        this.extendedLocations = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ulbxqtijlfriscxm")
    public suspend
    fun extensionOptions(`value`: Output<ResourceTypeRegistrationPropertiesExtensionOptionsArgs>) {
        this.extensionOptions = value
    }

    /**
     * @param value
     */
    @JvmName("jjlsnqvrqwggvacn")
    public suspend
    fun featuresRule(`value`: Output<ResourceTypeRegistrationPropertiesFeaturesRuleArgs>) {
        this.featuresRule = value
    }

    /**
     * @param value
     */
    @JvmName("icxlsgqfupfbccgc")
    public suspend
    fun identityManagement(`value`: Output<ResourceTypeRegistrationPropertiesIdentityManagementArgs>) {
        this.identityManagement = value
    }

    /**
     * @param value
     */
    @JvmName("xarabtcocnxdhhml")
    public suspend fun isPureProxy(`value`: Output<Boolean>) {
        this.isPureProxy = value
    }

    /**
     * @param value
     */
    @JvmName("knmwrksjilaswotx")
    public suspend fun linkedAccessChecks(`value`: Output<List<LinkedAccessCheckArgs>>) {
        this.linkedAccessChecks = value
    }

    @JvmName("rtvidjxyqjfvaebu")
    public suspend fun linkedAccessChecks(vararg values: Output<LinkedAccessCheckArgs>) {
        this.linkedAccessChecks = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("unfcdlrhmvjlgpow")
    public suspend fun linkedAccessChecks(values: List<Output<LinkedAccessCheckArgs>>) {
        this.linkedAccessChecks = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("hfvtstbhvddkvfhr")
    public suspend fun loggingRules(`value`: Output<List<LoggingRuleArgs>>) {
        this.loggingRules = value
    }

    @JvmName("difmvwcbimyjbcls")
    public suspend fun loggingRules(vararg values: Output<LoggingRuleArgs>) {
        this.loggingRules = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("vewomvtxrbislguk")
    public suspend fun loggingRules(values: List<Output<LoggingRuleArgs>>) {
        this.loggingRules = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("iildsxyacmyjerbe")
    public suspend fun management(`value`: Output<ResourceTypeRegistrationPropertiesManagementArgs>) {
        this.management = value
    }

    /**
     * @param value
     */
    @JvmName("parsjanrrqnvhpqn")
    public suspend fun marketplaceType(`value`: Output<String>) {
        this.marketplaceType = value
    }

    /**
     * @param value
     */
    @JvmName("fjcvemgtgqjloxxu")
    public suspend fun openApiConfiguration(`value`: Output<OpenApiConfigurationArgs>) {
        this.openApiConfiguration = value
    }

    /**
     * @param value The provisioned state of the resource.
     */
    @JvmName("nugxrxhpymvlhadw")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value
     */
    @JvmName("jbktyyiiexftgdng")
    public suspend fun regionality(`value`: Output<Either<String, Regionality>>) {
        this.regionality = value
    }

    /**
     * @param value
     */
    @JvmName("ixkpsvlqkerhmpvy")
    public suspend
    fun requestHeaderOptions(`value`: Output<ResourceTypeRegistrationPropertiesRequestHeaderOptionsArgs>) {
        this.requestHeaderOptions = value
    }

    /**
     * @param value
     */
    @JvmName("gcxgitxmddacqtos")
    public suspend fun requiredFeatures(`value`: Output<List<String>>) {
        this.requiredFeatures = value
    }

    @JvmName("hxivornwbbjsuvuv")
    public suspend fun requiredFeatures(vararg values: Output<String>) {
        this.requiredFeatures = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("goywbbilnkidlwes")
    public suspend fun requiredFeatures(values: List<Output<String>>) {
        this.requiredFeatures = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("naaedewayrqsnlws")
    public suspend
    fun resourceConcurrencyControlOptions(`value`: Output<Map<String, ResourceConcurrencyControlOptionArgs>>) {
        this.resourceConcurrencyControlOptions = value
    }

    /**
     * @param value
     */
    @JvmName("tdgqlhylnairtpcj")
    public suspend
    fun resourceDeletionPolicy(`value`: Output<Either<String, ResourceDeletionPolicy>>) {
        this.resourceDeletionPolicy = value
    }

    /**
     * @param value
     */
    @JvmName("ylgcpjbkiyiedpaf")
    public suspend
    fun resourceGraphConfiguration(`value`: Output<ResourceTypeRegistrationPropertiesResourceGraphConfigurationArgs>) {
        this.resourceGraphConfiguration = value
    }

    /**
     * @param value
     */
    @JvmName("wwhnqlvepekyuoeb")
    public suspend
    fun resourceMovePolicy(`value`: Output<ResourceTypeRegistrationPropertiesResourceMovePolicyArgs>) {
        this.resourceMovePolicy = value
    }

    /**
     * @param value
     */
    @JvmName("bwkqrvxnoonahxdq")
    public suspend fun routingType(`value`: Output<Either<String, RoutingType>>) {
        this.routingType = value
    }

    /**
     * @param value
     */
    @JvmName("upsjomffvanvjday")
    public suspend fun serviceTreeInfos(`value`: Output<List<ServiceTreeInfoArgs>>) {
        this.serviceTreeInfos = value
    }

    @JvmName("jpivwmknmjgurulj")
    public suspend fun serviceTreeInfos(vararg values: Output<ServiceTreeInfoArgs>) {
        this.serviceTreeInfos = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("aqctymthrraluhdq")
    public suspend fun serviceTreeInfos(values: List<Output<ServiceTreeInfoArgs>>) {
        this.serviceTreeInfos = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ijgvwxgfpsqwqrmq")
    public suspend
    fun subscriptionLifecycleNotificationSpecifications(`value`: Output<ResourceTypeRegistrationPropertiesSubscriptionLifecycleNotificationSpecificationsArgs>) {
        this.subscriptionLifecycleNotificationSpecifications = value
    }

    /**
     * @param value
     */
    @JvmName("ojwnxfevuolifosx")
    public suspend fun subscriptionStateRules(`value`: Output<List<SubscriptionStateRuleArgs>>) {
        this.subscriptionStateRules = value
    }

    @JvmName("faepprcalyjgdcpm")
    public suspend fun subscriptionStateRules(vararg values: Output<SubscriptionStateRuleArgs>) {
        this.subscriptionStateRules = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("fldckduhxgyrcsaf")
    public suspend fun subscriptionStateRules(values: List<Output<SubscriptionStateRuleArgs>>) {
        this.subscriptionStateRules = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("wiptwbbqihcletuq")
    public suspend fun swaggerSpecifications(`value`: Output<List<SwaggerSpecificationArgs>>) {
        this.swaggerSpecifications = value
    }

    @JvmName("hqmauvhwmmujaipk")
    public suspend fun swaggerSpecifications(vararg values: Output<SwaggerSpecificationArgs>) {
        this.swaggerSpecifications = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("matvcjwxkgajkftv")
    public suspend fun swaggerSpecifications(values: List<Output<SwaggerSpecificationArgs>>) {
        this.swaggerSpecifications = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("iwxlcchblwupbjum")
    public suspend
    fun templateDeploymentOptions(`value`: Output<ResourceTypeRegistrationPropertiesTemplateDeploymentOptionsArgs>) {
        this.templateDeploymentOptions = value
    }

    /**
     * @param value
     */
    @JvmName("cwwlxeckntpukqsx")
    public suspend fun throttlingRules(`value`: Output<List<ThrottlingRuleArgs>>) {
        this.throttlingRules = value
    }

    @JvmName("smdfubosjwoikgfu")
    public suspend fun throttlingRules(vararg values: Output<ThrottlingRuleArgs>) {
        this.throttlingRules = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("cqevesmavkbirarw")
    public suspend fun throttlingRules(values: List<Output<ThrottlingRuleArgs>>) {
        this.throttlingRules = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("fmdhxdacvtcyfuvt")
    public suspend fun allowedUnauthorizedActions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedUnauthorizedActions = mapped
    }

    /**
     * @param values
     */
    @JvmName("fskfdxtasavenrhv")
    public suspend fun allowedUnauthorizedActions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedUnauthorizedActions = mapped
    }

    /**
     * @param value
     */
    @JvmName("tgnuueudviqgbais")
    public suspend fun authorizationActionMappings(`value`: List<AuthorizationActionMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationActionMappings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rvyacjhbqfktlail")
    public suspend
    fun authorizationActionMappings(argument: List<suspend AuthorizationActionMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AuthorizationActionMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.authorizationActionMappings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("heebhwrvttruipan")
    public suspend fun authorizationActionMappings(
        vararg
        argument: suspend AuthorizationActionMappingArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AuthorizationActionMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.authorizationActionMappings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("khxxfmeskdyootsf")
    public suspend
    fun authorizationActionMappings(argument: suspend AuthorizationActionMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AuthorizationActionMappingArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.authorizationActionMappings = mapped
    }

    /**
     * @param values
     */
    @JvmName("lkbdmwspjxblqill")
    public suspend fun authorizationActionMappings(vararg values: AuthorizationActionMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizationActionMappings = mapped
    }

    /**
     * @param value
     */
    @JvmName("oaxwvoxiuwooipvf")
    public suspend
    fun checkNameAvailabilitySpecifications(`value`: ResourceTypeRegistrationPropertiesCheckNameAvailabilitySpecificationsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checkNameAvailabilitySpecifications = mapped
    }

    /**
     * @param argument
     */
    @JvmName("crfufhgbxpochmuy")
    public suspend
    fun checkNameAvailabilitySpecifications(argument: suspend ResourceTypeRegistrationPropertiesCheckNameAvailabilitySpecificationsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ResourceTypeRegistrationPropertiesCheckNameAvailabilitySpecificationsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.checkNameAvailabilitySpecifications = mapped
    }

    /**
     * @param value
     */
    @JvmName("eughcvgstnwwrvpt")
    public suspend fun defaultApiVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultApiVersion = mapped
    }

    /**
     * @param value
     */
    @JvmName("ontgkmbmahucatua")
    public suspend fun disallowedActionVerbs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disallowedActionVerbs = mapped
    }

    /**
     * @param values
     */
    @JvmName("papbxykrpntsxukx")
    public suspend fun disallowedActionVerbs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.disallowedActionVerbs = mapped
    }

    /**
     * @param value
     */
    @JvmName("fcxfeamdccmbjacj")
    public suspend fun enableAsyncOperation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAsyncOperation = mapped
    }

    /**
     * @param value
     */
    @JvmName("wqxkcsftnomlgaiy")
    public suspend fun enableThirdPartyS2S(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableThirdPartyS2S = mapped
    }

    /**
     * @param value
     */
    @JvmName("xcikifkmabibvbqm")
    public suspend fun endpoints(`value`: List<ResourceTypeEndpointArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    /**
     * @param argument
     */
    @JvmName("pkwwkendbvxnruad")
    public suspend fun endpoints(argument: List<suspend ResourceTypeEndpointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceTypeEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param argument
     */
    @JvmName("fpmrggahnxalpqxv")
    public suspend fun endpoints(
        vararg
        argument: suspend ResourceTypeEndpointArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ResourceTypeEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param argument
     */
    @JvmName("uamhpmlbpcyolmig")
    public suspend fun endpoints(argument: suspend ResourceTypeEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceTypeEndpointArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param values
     */
    @JvmName("rsebrhbnqjprlyrt")
    public suspend fun endpoints(vararg values: ResourceTypeEndpointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    /**
     * @param value
     */
    @JvmName("gvjfngpcrmkhgmdt")
    public suspend fun extendedLocations(`value`: List<ExtendedLocationOptionsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocations = mapped
    }

    /**
     * @param argument
     */
    @JvmName("stqqiasvlmhydoxt")
    public suspend
    fun extendedLocations(argument: List<suspend ExtendedLocationOptionsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExtendedLocationOptionsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.extendedLocations = mapped
    }

    /**
     * @param argument
     */
    @JvmName("meeirsjudcbkkohk")
    public suspend fun extendedLocations(
        vararg
        argument: suspend ExtendedLocationOptionsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ExtendedLocationOptionsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.extendedLocations = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rmiqwgkcgepiktsi")
    public suspend
    fun extendedLocations(argument: suspend ExtendedLocationOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ExtendedLocationOptionsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.extendedLocations = mapped
    }

    /**
     * @param values
     */
    @JvmName("rhuctsbwyvjqdpkn")
    public suspend fun extendedLocations(vararg values: ExtendedLocationOptionsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.extendedLocations = mapped
    }

    /**
     * @param value
     */
    @JvmName("toiiriqodxodxnsb")
    public suspend
    fun extensionOptions(`value`: ResourceTypeRegistrationPropertiesExtensionOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensionOptions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ukwqdxvrcibdngqn")
    public suspend
    fun extensionOptions(argument: suspend ResourceTypeRegistrationPropertiesExtensionOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceTypeRegistrationPropertiesExtensionOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.extensionOptions = mapped
    }

    /**
     * @param value
     */
    @JvmName("cjjkewheersvqvxq")
    public suspend fun featuresRule(`value`: ResourceTypeRegistrationPropertiesFeaturesRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.featuresRule = mapped
    }

    /**
     * @param argument
     */
    @JvmName("uubsbpqxlcfgdpdi")
    public suspend
    fun featuresRule(argument: suspend ResourceTypeRegistrationPropertiesFeaturesRuleArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceTypeRegistrationPropertiesFeaturesRuleArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.featuresRule = mapped
    }

    /**
     * @param value
     */
    @JvmName("huvkbfowpupymxky")
    public suspend
    fun identityManagement(`value`: ResourceTypeRegistrationPropertiesIdentityManagementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityManagement = mapped
    }

    /**
     * @param argument
     */
    @JvmName("kdgrhqcfjlibargb")
    public suspend
    fun identityManagement(argument: suspend ResourceTypeRegistrationPropertiesIdentityManagementArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceTypeRegistrationPropertiesIdentityManagementArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.identityManagement = mapped
    }

    /**
     * @param value
     */
    @JvmName("uejbnvnrmbespswe")
    public suspend fun isPureProxy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isPureProxy = mapped
    }

    /**
     * @param value
     */
    @JvmName("xaondfccgpafstxb")
    public suspend fun linkedAccessChecks(`value`: List<LinkedAccessCheckArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedAccessChecks = mapped
    }

    /**
     * @param argument
     */
    @JvmName("jgfauwehdyeybcgl")
    public suspend
    fun linkedAccessChecks(argument: List<suspend LinkedAccessCheckArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LinkedAccessCheckArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.linkedAccessChecks = mapped
    }

    /**
     * @param argument
     */
    @JvmName("hjfbdytvbqsbsxoq")
    public suspend fun linkedAccessChecks(
        vararg
        argument: suspend LinkedAccessCheckArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LinkedAccessCheckArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.linkedAccessChecks = mapped
    }

    /**
     * @param argument
     */
    @JvmName("egbkfyyqejhpfcyq")
    public suspend fun linkedAccessChecks(argument: suspend LinkedAccessCheckArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LinkedAccessCheckArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.linkedAccessChecks = mapped
    }

    /**
     * @param values
     */
    @JvmName("gidjupgsluusuvtc")
    public suspend fun linkedAccessChecks(vararg values: LinkedAccessCheckArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkedAccessChecks = mapped
    }

    /**
     * @param value
     */
    @JvmName("hwwamwilglhabjry")
    public suspend fun loggingRules(`value`: List<LoggingRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggingRules = mapped
    }

    /**
     * @param argument
     */
    @JvmName("sqtxllaacxhmqkkg")
    public suspend fun loggingRules(argument: List<suspend LoggingRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { LoggingRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.loggingRules = mapped
    }

    /**
     * @param argument
     */
    @JvmName("nddmjffeylhrjwlj")
    public suspend fun loggingRules(vararg argument: suspend LoggingRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { LoggingRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.loggingRules = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rgisbyahntdkrjko")
    public suspend fun loggingRules(argument: suspend LoggingRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LoggingRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.loggingRules = mapped
    }

    /**
     * @param values
     */
    @JvmName("hnewxkejveospkvw")
    public suspend fun loggingRules(vararg values: LoggingRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loggingRules = mapped
    }

    /**
     * @param value
     */
    @JvmName("ruimsbcwckuslakh")
    public suspend fun management(`value`: ResourceTypeRegistrationPropertiesManagementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.management = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ynyxocodbvpbvxcc")
    public suspend
    fun management(argument: suspend ResourceTypeRegistrationPropertiesManagementArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceTypeRegistrationPropertiesManagementArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.management = mapped
    }

    /**
     * @param value
     */
    @JvmName("biwtsanmhkimlsnh")
    public suspend fun marketplaceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.marketplaceType = mapped
    }

    /**
     * @param value
     */
    @JvmName("dyakjhrdgdqpmnda")
    public suspend fun openApiConfiguration(`value`: OpenApiConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.openApiConfiguration = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ltjxsskttinqfvnu")
    public suspend
    fun openApiConfiguration(argument: suspend OpenApiConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = OpenApiConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.openApiConfiguration = mapped
    }

    /**
     * @param value The provisioned state of the resource.
     */
    @JvmName("mgpinicwhhvliydg")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The provisioned state of the resource.
     */
    @JvmName("dhyoscqhnunxdiow")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The provisioned state of the resource.
     */
    @JvmName("liwcfbuhfjrggyoq")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value
     */
    @JvmName("rxhvsuedjrekrvjs")
    public suspend fun regionality(`value`: Either<String, Regionality>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionality = mapped
    }

    /**
     * @param value
     */
    @JvmName("hceigwxfownrnwjh")
    public fun regionality(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Regionality>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regionality = mapped
    }

    /**
     * @param value
     */
    @JvmName("aukfljmubwmcbveh")
    public fun regionality(`value`: Regionality) {
        val toBeMapped = Either.ofRight<String, Regionality>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regionality = mapped
    }

    /**
     * @param value
     */
    @JvmName("bkhdysenyiyvhkwi")
    public suspend
    fun requestHeaderOptions(`value`: ResourceTypeRegistrationPropertiesRequestHeaderOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestHeaderOptions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("juscacbcuskhwqna")
    public suspend
    fun requestHeaderOptions(argument: suspend ResourceTypeRegistrationPropertiesRequestHeaderOptionsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ResourceTypeRegistrationPropertiesRequestHeaderOptionsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.requestHeaderOptions = mapped
    }

    /**
     * @param value
     */
    @JvmName("rclpkharbolkqshb")
    public suspend fun requiredFeatures(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiredFeatures = mapped
    }

    /**
     * @param values
     */
    @JvmName("yjwfjepuilknbnub")
    public suspend fun requiredFeatures(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requiredFeatures = mapped
    }

    /**
     * @param value
     */
    @JvmName("javecyguxsrmhulk")
    public suspend
    fun resourceConcurrencyControlOptions(`value`: Map<String, ResourceConcurrencyControlOptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceConcurrencyControlOptions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("agrkagxflpvdiggw")
    public suspend fun resourceConcurrencyControlOptions(
        vararg
        argument: Pair<String, suspend ResourceConcurrencyControlOptionArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ResourceConcurrencyControlOptionArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.resourceConcurrencyControlOptions = mapped
    }

    /**
     * @param values
     */
    @JvmName("hykbouxispxwxdco")
    public fun resourceConcurrencyControlOptions(
        vararg
        values: Pair<String, ResourceConcurrencyControlOptionArgs>,
    ) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceConcurrencyControlOptions = mapped
    }

    /**
     * @param value
     */
    @JvmName("xfncmgvjtvyyrkgv")
    public suspend fun resourceDeletionPolicy(`value`: Either<String, ResourceDeletionPolicy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceDeletionPolicy = mapped
    }

    /**
     * @param value
     */
    @JvmName("gpiukqqnnxpioish")
    public fun resourceDeletionPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ResourceDeletionPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceDeletionPolicy = mapped
    }

    /**
     * @param value
     */
    @JvmName("smubdjjmndmwtmvm")
    public fun resourceDeletionPolicy(`value`: ResourceDeletionPolicy) {
        val toBeMapped = Either.ofRight<String, ResourceDeletionPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceDeletionPolicy = mapped
    }

    /**
     * @param value
     */
    @JvmName("srcoxbkqjtgbfuah")
    public suspend
    fun resourceGraphConfiguration(`value`: ResourceTypeRegistrationPropertiesResourceGraphConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGraphConfiguration = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rvxrobdblrxuyopd")
    public suspend
    fun resourceGraphConfiguration(argument: suspend ResourceTypeRegistrationPropertiesResourceGraphConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ResourceTypeRegistrationPropertiesResourceGraphConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.resourceGraphConfiguration = mapped
    }

    /**
     * @param value
     */
    @JvmName("tbgmhfigvmxnbtbj")
    public suspend
    fun resourceMovePolicy(`value`: ResourceTypeRegistrationPropertiesResourceMovePolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceMovePolicy = mapped
    }

    /**
     * @param argument
     */
    @JvmName("hklkrgdptnscfrdm")
    public suspend
    fun resourceMovePolicy(argument: suspend ResourceTypeRegistrationPropertiesResourceMovePolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceTypeRegistrationPropertiesResourceMovePolicyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.resourceMovePolicy = mapped
    }

    /**
     * @param value
     */
    @JvmName("kbkiwskuatokldrh")
    public suspend fun routingType(`value`: Either<String, RoutingType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingType = mapped
    }

    /**
     * @param value
     */
    @JvmName("gxlqirxjihnflnfh")
    public fun routingType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RoutingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routingType = mapped
    }

    /**
     * @param value
     */
    @JvmName("yldvrqtvrxicvbqt")
    public fun routingType(`value`: RoutingType) {
        val toBeMapped = Either.ofRight<String, RoutingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routingType = mapped
    }

    /**
     * @param value
     */
    @JvmName("opnxxjpfvuecerwj")
    public suspend fun serviceTreeInfos(`value`: List<ServiceTreeInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceTreeInfos = mapped
    }

    /**
     * @param argument
     */
    @JvmName("etbqjmibnbqxoydn")
    public suspend
    fun serviceTreeInfos(argument: List<suspend ServiceTreeInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceTreeInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceTreeInfos = mapped
    }

    /**
     * @param argument
     */
    @JvmName("sciykxkunhraavdu")
    public suspend fun serviceTreeInfos(
        vararg
        argument: suspend ServiceTreeInfoArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ServiceTreeInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceTreeInfos = mapped
    }

    /**
     * @param argument
     */
    @JvmName("hycswcjuoskmedtb")
    public suspend fun serviceTreeInfos(argument: suspend ServiceTreeInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ServiceTreeInfoArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.serviceTreeInfos = mapped
    }

    /**
     * @param values
     */
    @JvmName("pqkscsxftcsjjbgm")
    public suspend fun serviceTreeInfos(vararg values: ServiceTreeInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceTreeInfos = mapped
    }

    /**
     * @param value
     */
    @JvmName("xxljuvegddwuvjcm")
    public suspend
    fun subscriptionLifecycleNotificationSpecifications(`value`: ResourceTypeRegistrationPropertiesSubscriptionLifecycleNotificationSpecificationsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionLifecycleNotificationSpecifications = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xrdfoktferiqapmx")
    public suspend
    fun subscriptionLifecycleNotificationSpecifications(argument: suspend ResourceTypeRegistrationPropertiesSubscriptionLifecycleNotificationSpecificationsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ResourceTypeRegistrationPropertiesSubscriptionLifecycleNotificationSpecificationsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.subscriptionLifecycleNotificationSpecifications = mapped
    }

    /**
     * @param value
     */
    @JvmName("psgallfamndurtoe")
    public suspend fun subscriptionStateRules(`value`: List<SubscriptionStateRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionStateRules = mapped
    }

    /**
     * @param argument
     */
    @JvmName("pjijfejtubtgtcmr")
    public suspend
    fun subscriptionStateRules(argument: List<suspend SubscriptionStateRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SubscriptionStateRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subscriptionStateRules = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ekbsvpgfntucabay")
    public suspend fun subscriptionStateRules(
        vararg
        argument: suspend SubscriptionStateRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SubscriptionStateRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subscriptionStateRules = mapped
    }

    /**
     * @param argument
     */
    @JvmName("kcroyyxrvdooykte")
    public suspend
    fun subscriptionStateRules(argument: suspend SubscriptionStateRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubscriptionStateRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.subscriptionStateRules = mapped
    }

    /**
     * @param values
     */
    @JvmName("tpgekhfhqanborya")
    public suspend fun subscriptionStateRules(vararg values: SubscriptionStateRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subscriptionStateRules = mapped
    }

    /**
     * @param value
     */
    @JvmName("uhrkanopbeuvuhvi")
    public suspend fun swaggerSpecifications(`value`: List<SwaggerSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.swaggerSpecifications = mapped
    }

    /**
     * @param argument
     */
    @JvmName("psfqykespwqfokeq")
    public suspend
    fun swaggerSpecifications(argument: List<suspend SwaggerSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SwaggerSpecificationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.swaggerSpecifications = mapped
    }

    /**
     * @param argument
     */
    @JvmName("pairvmcfmqiuglpn")
    public suspend fun swaggerSpecifications(
        vararg
        argument: suspend SwaggerSpecificationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SwaggerSpecificationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.swaggerSpecifications = mapped
    }

    /**
     * @param argument
     */
    @JvmName("hfsodjcygmtpsmyc")
    public suspend
    fun swaggerSpecifications(argument: suspend SwaggerSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SwaggerSpecificationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.swaggerSpecifications = mapped
    }

    /**
     * @param values
     */
    @JvmName("hmlycwvqbmskbsnl")
    public suspend fun swaggerSpecifications(vararg values: SwaggerSpecificationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.swaggerSpecifications = mapped
    }

    /**
     * @param value
     */
    @JvmName("pmihefrigqjqnbpi")
    public suspend
    fun templateDeploymentOptions(`value`: ResourceTypeRegistrationPropertiesTemplateDeploymentOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateDeploymentOptions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("scgplmjegftalkun")
    public suspend
    fun templateDeploymentOptions(argument: suspend ResourceTypeRegistrationPropertiesTemplateDeploymentOptionsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ResourceTypeRegistrationPropertiesTemplateDeploymentOptionsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.templateDeploymentOptions = mapped
    }

    /**
     * @param value
     */
    @JvmName("phvxnhavpwdbcmtm")
    public suspend fun throttlingRules(`value`: List<ThrottlingRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttlingRules = mapped
    }

    /**
     * @param argument
     */
    @JvmName("fayrnafnauqnjjgx")
    public suspend fun throttlingRules(argument: List<suspend ThrottlingRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ThrottlingRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.throttlingRules = mapped
    }

    /**
     * @param argument
     */
    @JvmName("kwwbipreowtnohck")
    public suspend fun throttlingRules(
        vararg
        argument: suspend ThrottlingRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ThrottlingRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.throttlingRules = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ctaopjhlcwsytrnl")
    public suspend fun throttlingRules(argument: suspend ThrottlingRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ThrottlingRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.throttlingRules = mapped
    }

    /**
     * @param values
     */
    @JvmName("ujfquglhguhaaqhb")
    public suspend fun throttlingRules(vararg values: ThrottlingRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.throttlingRules = mapped
    }

    internal fun build(): ResourceTypeRegistrationPropertiesArgs =
        ResourceTypeRegistrationPropertiesArgs(
            allowedUnauthorizedActions = allowedUnauthorizedActions,
            authorizationActionMappings = authorizationActionMappings,
            checkNameAvailabilitySpecifications = checkNameAvailabilitySpecifications,
            defaultApiVersion = defaultApiVersion,
            disallowedActionVerbs = disallowedActionVerbs,
            enableAsyncOperation = enableAsyncOperation,
            enableThirdPartyS2S = enableThirdPartyS2S,
            endpoints = endpoints,
            extendedLocations = extendedLocations,
            extensionOptions = extensionOptions,
            featuresRule = featuresRule,
            identityManagement = identityManagement,
            isPureProxy = isPureProxy,
            linkedAccessChecks = linkedAccessChecks,
            loggingRules = loggingRules,
            management = management,
            marketplaceType = marketplaceType,
            openApiConfiguration = openApiConfiguration,
            provisioningState = provisioningState,
            regionality = regionality,
            requestHeaderOptions = requestHeaderOptions,
            requiredFeatures = requiredFeatures,
            resourceConcurrencyControlOptions = resourceConcurrencyControlOptions,
            resourceDeletionPolicy = resourceDeletionPolicy,
            resourceGraphConfiguration = resourceGraphConfiguration,
            resourceMovePolicy = resourceMovePolicy,
            routingType = routingType,
            serviceTreeInfos = serviceTreeInfos,
            subscriptionLifecycleNotificationSpecifications = subscriptionLifecycleNotificationSpecifications,
            subscriptionStateRules = subscriptionStateRules,
            swaggerSpecifications = swaggerSpecifications,
            templateDeploymentOptions = templateDeploymentOptions,
            throttlingRules = throttlingRules,
        )
}
