@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesResourceGraphConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property apiVersion
 * @property enabled
 */
public data class ResourceTypeRegistrationPropertiesResourceGraphConfigurationArgs(
    public val apiVersion: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesResourceGraphConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesResourceGraphConfigurationArgs =
        com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesResourceGraphConfigurationArgs.builder()
            .apiVersion(apiVersion?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceTypeRegistrationPropertiesResourceGraphConfigurationArgs].
 */
@PulumiTagMarker
public class ResourceTypeRegistrationPropertiesResourceGraphConfigurationArgsBuilder internal
constructor() {
    private var apiVersion: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value
     */
    @JvmName("sonkgibqlgmqotyg")
    public suspend fun apiVersion(`value`: Output<String>) {
        this.apiVersion = value
    }

    /**
     * @param value
     */
    @JvmName("julpjfynlmgsmenr")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value
     */
    @JvmName("nsnggkaabwqfebdi")
    public suspend fun apiVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiVersion = mapped
    }

    /**
     * @param value
     */
    @JvmName("gfikafcoounsbefh")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): ResourceTypeRegistrationPropertiesResourceGraphConfigurationArgs =
        ResourceTypeRegistrationPropertiesResourceGraphConfigurationArgs(
            apiVersion = apiVersion,
            enabled = enabled,
        )
}
